#' @importFrom stats dt ecdf integrate median quantile sd rgeom ks.test p.adjust
#' @importFrom grDevices col2rgb colors nclass.FD
#' @importFrom graphics hist
#' @importFrom utils data head read.csv tail type.convert write.csv
#' @importFrom dplyr %>% mutate
#' @importFrom magrittr set_names set_rownames set_colnames %<>% mod
#' @importFrom colorspace sequential_hcl
#' @importFrom RColorBrewer brewer.pal
#' @importFrom colorRamps primary.colors
#' @importFrom data.table as.data.table rbindlist data.table fread := melt is.data.table
#' @importFrom data.table setorderv frank setnames rbindlist copy transpose setDT
#' @importFrom plotly add_annotations add_trace orca plot_ly rename_ subplot layout
#' @importFrom ggplot2 aes geom_jitter geom_line geom_ribbon geom_violin ggplot element_text
#' @importFrom ggplot2 guides scale_color_manual scale_colour_manual scale_fill_manual
#' @importFrom ggplot2 scale_x_continuous scale_x_log10 facet_wrap theme_set theme_grey theme
#' @importFrom shiny req
#' @importFrom stringi stri_detect_regex stri_detect_fixed stri_locate_all stri_replace
#' @importFrom stringi stri_rand_strings stri_sub
#' @importFrom httr POST GET add_headers content authenticate
#' @importFrom reshape2 acast
#' @importFrom knitr kable
#' @importFrom methods hasArg
#' @useDynLib IOHanalyzer
NULL
# Ugly hack, but appears to be required to appease CRAN
utils::globalVariables(c(".", "algId", "run", "ERT", "RT", "group",
                         "DIM", "Fvalue", "lower", "upper", "target", "format",
                         "runtime", "parId", "instance", "input", "funcId",
                         "budget", "dimension", "loss", "name", "optimizer_name",
                         "rescale", "maxRT", "algnames", ".SD", "function_class", "ID", "ids"))

options(shiny.port = 4242)

.onLoad <- function(libname, pkgname) {
  op <- options()
  op.IOHanalyzer <- list(
    IOHanalyzer.ID_vars = c("algId"),
    IOHanalyzer.quantiles = c(2, 5, 10, 25, 50, 75, 90, 95, 98) / 100.,
    IOHanalyzer.max_samples = 100,
    IOHanalyzer.backend = 'plotly',
    IOHanalyzer.bgcolor = 'rgb(230,230,230)',
    IOHanalyzer.gridcolor = 'rgb(255,255,255)',
    IOHanalyzer.tickcolor = 'rgb(51,51,51)',
    IOHanalyzer.figure_width = 1000,
    IOHanalyzer.figure_height = 1000,
    IOHanalyzer.legend_location = 'below',
    IOHanalyzer.legend_fontsize = 13,
    IOHanalyzer.custom_legend_x = 0.5,
    IOHanalyzer.custom_legend_y = -0.2,
    IOHanalyzer.label_fontsize = 16,
    IOHanalyzer.title_fontsize = 16,
    IOHanalyzer.tick_fontsize = 12,
    IOHanalyzer.linewidth = 2,
    IOHanalyzer.markersize = 4,
    IOHanalyzer.max_colors = 2, #Set to 2 since colorbrewer only works with >= 3 colors
    IOHanalyzer.orca_use_gpu = TRUE, #Can be disabled to stop orca using gpu-accelleration
    IOHanalyzer.annotation_x = 0.5,
    IOHanalyzer.annotation_y = 1,
    IOHanalyzer.margin_horizontal = 0.02,
    IOHanalyzer.margin_vertical = 0.02
  )
  toset <- !(names(op.IOHanalyzer) %in% names(op))
  if (any(toset)) options(op.IOHanalyzer[toset])

  invisible()
}

IOHanalyzer_env <- new.env(parent = emptyenv())

.mean <- function(x) mean(x, na.rm = T)
.median <- function(x) median(x, na.rm = T)
.sd <- function(x) sd(x, na.rm = T)
.sum <- function(x) sum(x, na.rm = T)

# Quantile function for discrete values
IOHanalyzer_env$D_quantile <- function(x, pct = NULL) {
  if (is.null(pct)) pct <- getOption("IOHanalyzer.quantiles")
  tryCatch(
    quantile(x, pct, names = F, type = 3, na.rm = T),
    error = function(e) rep(NA, length(pct)),
    warning = function(w) rep(NA, length(pct))
  )
}

# Quantile function for real values
IOHanalyzer_env$C_quantile <- function(x, pct = NULL) {
  if (is.null(pct)) pct <- getOption("IOHanalyzer.quantiles")
  tryCatch(
    quantile(x, pct, names = F, na.rm = T),
    error = function(e) rep(NA, length(pct)),
    warning = function(w) rep(NA, length(pct))
  )
}

IOHprofiler <- 'IOHprofiler'
COCO <- 'COCO'
BIBOJ_COCO <- 'BIBOJ_COCO'
TWO_COL <- 'TWO_COL'
AUTOMATIC <- 'AUTOMATIC'
NEVERGRAD <- 'NEVERGRAD'
SOS <- 'SOS'

#' IOHanalyzer: Data Analysis Part of IOHprofiler
#'
#' The data analysis module for the Iterative Optimization Heuristics Profiler (IOHprofiler).
#' This module provides statistical analysis methods for the benchmark data generated by
#' optimization heuristics, which can be visualized through a
#' web-based interface. The benchmark data is usually generated by the
#' experimentation module, called IOHexperimenter. IOHanalyzer also supports
#' the widely used COCO (Comparing Continuous Optimisers) data format for benchmarking.
#'
#' @section Functions:
#' The IOHanalyzer consists of 3 main functionalities:
#' \itemize{
#' \item Reading and alligning data from different heuristics, such as IOHExperimenter.
#' This is done using the \code{\link{DataSet}} and \code{\link{DataSetList}} functions
#' \item Processing and summarizing this data
#' \item Creating various plots
#' }
#'
#' @docType package
#' @name IOHanalyzer
#' @examples
#' path <- system.file("extdata", "ONE_PLUS_LAMDA_EA", package="IOHanalyzer")
#' dsList <- DataSetList(path)
#' summary(dsList)
#' Plot.RT.Single_Func(dsList[1])
#'
#' @examples
#' \dontrun{
#' runServer()
#' }
NULL
