% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCAR_rgeneric.R
\name{inla.rgeneric.MCAR.model}
\alias{inla.rgeneric.MCAR.model}
\alias{inla.MCAR.model}
\title{\eqn{MCAR(\alpha, \Lambda)}: Proper multivariate CAR latent effect
with a common autorcorrelation parameter.}
\usage{
inla.rgeneric.MCAR.model(cmd, theta)

inla.MCAR.model(...)
}
\arguments{
\item{...}{Arguments to be passed to 'inla.rgeneric.define'.}

\item{cmd}{Arguments used by latent effects defined using the 'rgeneric'
latent effect.}

\item{theta}{Vector of hyperparameters.}
}
\value{
This is used internally by the 'INLA::inla()'.
}
\description{
Multivariate generalization of the proper conditional
autorregresive model with one common correlation parameter. The matrix
which models the variability between diseases is a symmetric matrix with
the inverse of the marginal precisions on the diagonal elements and the
correlation parameters divided by the square root of the precisions on
the off-diagonal elements.
}
\details{
This function is used to define a latent effect that is a
multivariate spatial effect with a proper conditional autorregresive
distribution (with a common spatial autocorrelation parameter) and
a symmetric matrix in order to model the whitin-disease and the
between-diseases variability, respectively. Due to this effect is a
multivariate spatial latent effect this function requires the following
arguments when defining the latent effect:
\itemize{

  \item \emph{W} Adjacency SPARSE matrix for spatial effect in the basic
  binary code.

  \item \emph{k} Number of diseases of the multivariate study.

  \item \emph{alpha.min} Minimum value of the spatial autocorrelation
  parameter.

  \item \emph{alpha.max} Maximum value of the spatial autocorrelation
  parameter.

}

This model is defined using the 'f()' function and an index in order to
identify the spatial areas. See the example.
}
\section{Prior distributions of the hyperparameters}{

The hyperparamenters of this lattent effect are the marginal precisions of
each disease which are equal to the number of diseases, the correlation
parameters for the whole pair of diseases and the common spatial
autocorrelation parameter.
}

\examples{

\donttest{
if (require("INLA", quietly = TRUE)) {
require(spdep)
require(spData)
require(rgdal)

#Load SIDS data
nc.sids <- readOGR(system.file("shapes/sids.shp", package="spData")[1])
proj4string(nc.sids) <- CRS("+proj=longlat +ellps=clrk66")

#Compute adjacency matrix, as nb object 'adj' and sparse matrix 'W'
adj <- poly2nb(nc.sids)
W <- as(nb2mat(adj, style = "B"), "Matrix")

#Compute expected cases
r74 <- sum(nc.sids$SID74) / sum(nc.sids$BIR74)
nc.sids$EXP74 <- r74 * nc.sids$BIR74
nc.sids$SMR74 <- nc.sids$SID74 / nc.sids$EXP74
nc.sids$NWPROP74 <- nc.sids$NWBIR74 / nc.sids$BIR74

r79 <- sum(nc.sids$SID79) / sum(nc.sids$BIR79)
nc.sids$EXP79 <- r79 * nc.sids$BIR79
nc.sids$SMR79 <- nc.sids$SID79 / nc.sids$EXP79
nc.sids$NWPROP79 <- nc.sids$NWBIR79 / nc.sids$BIR79

# Data (replicated to assess scalability)

#Real data
n.rep <- 1
d <- list(OBS = c(nc.sids$SID74, nc.sids$SID79),
          NWPROP = c(nc.sids$NWPROP74, nc.sids$NWPROP79),
          EXP = c(nc.sids$EXP74, nc.sids$EXP79))
d <- lapply(d, function(X) { rep(X, n.rep)})
d$idx <- 1:length(d$OBS)

# Model parameters
k <- 2 * n.rep #Number of diseases
alpha.min <- 0
alpha.max <- 1

#Define MCAR model
#model <- inla.rgeneric.define(inla.rgeneric.MCAR.model, debug = FALSE,
#  k = k, W = W, alpha.min = alpha.min, alpha.max = alpha.max)
model <- inla.MCAR.model(k = k, W = W, alpha.min = alpha.min, alpha.max = alpha.max)


#Fit model
r <- inla(OBS ~ 1 + f(idx, model = model),
  data = d, E = EXP, family = "poisson",
  control.compute = list(config = TRUE),
  control.predictor = list(compute = TRUE))

summary(r)

# Transformed parameters
r.hyperpar <- inla.MCAR.transform(r, k = 2, model = "PMCAR",
  alpha.min = alpha.min, alpha.max = alpha.max)
r.hyperpar$summary.hyperpar

#Get fitted data, i.e., relative risk
nc.sids$FITTED74 <- r$summary.fitted.values[1:100, "mean"]
nc.sids$FITTED79 <- r$summary.fitted.values[100 + 1:100, "mean"]

#Display fitted relative risks
dev.new()
spplot(nc.sids, c("SMR74", "FITTED74", "SMR79", "FITTED79"))


# Showing results of the MCAR: multivariate proper CAR.

#Show marginals of alpha, tau1, tau2
marg.alpha <- inla.tmarginal(
  function(x) alpha.min + (alpha.max - alpha.min) / (1 + exp(-x)),
  r$marginals.hyperpar[[1]])

marg.tau1 <- inla.tmarginal(
  function(x) exp(x),
  r$marginals.hyperpar[[2]])

marg.tau2 <- inla.tmarginal(
  function(x) exp(x),
  r$marginals.hyperpar[[3]])

dev.new()

oldpar <- par(mfrow = c(2, 2))

plot(marg.alpha, main="alpha", type="l")
plot(marg.tau1, main = "tau1", type = "l")
plot(marg.tau2, main = "tau2", type = "l")

par(oldpar)

## Running UNIVARIATE MODEL

#Real data
n.rep <- 1
d <- list(OBS = nc.sids$SID74,
          NWPROP = nc.sids$NWPROP74,
          EXP = nc.sids$EXP74)
d <- lapply(d, function(X) { rep(X, n.rep)})
d$idx <- 1:length(d$OBS)

#Fit model
r.uni <- inla(OBS ~ 1 + f(idx, model = "besag", graph = W),
              data = d, E = EXP, family = "poisson",
              control.predictor = list(compute = TRUE))

summary(r.uni)

nc.sids$FITTED74.uni <- r.uni$summary.fitted.values[ , "mean"]

#Display univariate VS multivariate  fitted relative risks.
dev.new()
spplot(nc.sids, c("SMR74", "FITTED74", "FITTED74.uni"))
spplot(nc.sids, c("FITTED74", "FITTED74.uni"),
       main=list(label="Relative risk estimation",cex=2))
dev.new()
plot(nc.sids$FITTED74.uni, nc.sids$FITTED74,
     main="Relative Risk estimations", xlab="Univariate RR estimations"
     , ylab="Multivariate RR estimations")
abline(h=0, col="grey")
abline(v=0, col="grey")
abline(a=0, b=1, col="red")

#Plot posterior mean of the spatial effects univ VS multi

nc.sids$m.uni <- r.uni$summary.random$idx[, "mean"]
nc.sids$m.mult <- r$summary.random$idx[1:100, "mean"]
dev.new()
plot(nc.sids$m.uni, nc.sids$m.mult,
     main="Posterior mean of the spatial effect",
     xlab="Uni. post. means", ylab="Mult. post. means")
abline(h=0, col="grey")
abline(v=0, col="grey")
abline(a=0, b=1, col="red")

dev.new()
spplot(nc.sids, c("m.mult", "m.uni"),
       main=list(label="Post. mean spatial effect",cex=2))
}
}

}
