% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_signif_code.R
\name{get_signif_code}
\alias{get_signif_code}
\title{Create a code indicating the significance of values given by p_val.}
\usage{
get_signif_code(p_val)
}
\arguments{
\item{p_val}{A vector with the p-values of the smoothing term.}
}
\value{
The function returns a character vector of the same length then the
input vector, with one symbol for each p-value.
}
\description{
\code{get_signif_code} is a helper function for \code{\link{model_gam}} and
\code{\link{model_gamm}} to create an easy-to-read output for the significance
of the smoothing term in the GAM(M)s (shown in the \code{signif_code}
column of the output tibbles).
}
\details{
The following code is adopted from \code{summary.gam}:
\tabular{lllll}{
  " "  \tab = not significant (> .1)\cr
  "."  \tab = close to significant (.05 < .1)\cr
  "*"  \tab  = significant (.01 < .05)\cr
  "**"  \tab = highly significant (.001 < 0.01)\cr
  "***"  \tab = absolute significant (<= .001)
}
}
\examples{
x <- tibble::tibble(p_val = list("test", NA, runif(1, 0, .1), runif(1, 0, .01)))
x$code <- get_signif_code(x$p_val)
}
\seealso{
\code{\link{model_gam}}, \code{\link{model_gamm}}
}
\keyword{internal}
