% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trend.R
\name{plot_trend}
\alias{plot_trend}
\title{Create indicator trend plot}
\usage{
plot_trend(trend_tbl, pos_label = "topleft")
}
\arguments{
\item{trend_tbl}{Output tibble from the \code{\link{model_trend}} function.}

\item{pos_label}{Specifies the position of the annotation in the plot. Should
be one of "topleft" (default), "topright", "bottomleft" or "bottomright".
For more details see \code{\link{place_text}}.}
}
\value{
The function returns a list of \code{\link[ggplot2]{ggplot}} objects;
 one for each indicator.
}
\description{
\code{plot_trend} creates for each indicator (IND) in the input tibble a
time series plot including the smoothed trend with 95\% confidence interval
 and the corresponding p- value based on the IND ~ time GAM.
}
\examples{
# Using the example data
trend_tbl <- model_trend_ex
pt <- plot_trend(trend_tbl)
# Show single plots using indicator names or indices
pt[[2]]
pt$Sprat
# Show all plots together
gridExtra::grid.arrange(grobs = pt)
}
\seealso{
\code{\link{model_trend}} that generates the model tibble for this function
}
