% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILSArename.R
\name{ILSArename}
\alias{ILSArename}
\title{Rename \code{\link{ILSAmerge}} files}
\usage{
ILSArename(
  inputdir = getwd(),
  codeTOname = TRUE,
  overwrite = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{inputdir}{a string indicating the path were \code{\link{ILSAmerge}} files are stored.}

\item{codeTOname}{a logical value indicating if files should be renamed from
codes to names (\code{TRUE}) or from names to codes (\code{FALSE}).
Default is \code{TRUE}.}

\item{overwrite}{a logical value indicating if files should be overwritten.
If \code{FALSE}, files will be copied with the new names. Default is \code{TRUE}.}

\item{quiet}{a logical value if progress should be
shown. Default is \code{FALSE}.}
}
\value{
Renames or copies files produced by \code{\link{ILSAmerge}}.
}
\description{
Renames files produced by \code{\link{ILSAmerge}} from name codes to comprehensible names 
including the study name, year and respondent.
This function has been tested to behave correctly for: 'TIMSS', 'TIMSS Advanced', 
'PIRLS', 'ICCS', 'ICILS', 'CIVED', 'REDS', 'RLII', and 'SITES' (2006).
}
\examples{

# Merge files
dir.create(file.path(tempdir(),"REDS2021"),showWarnings = FALSE)
ILSAmerge(inputdir = system.file("extdata/reds", package = "ILSAmerge"), 
outputdir = file.path(tempdir(),"REDS2021"))

# Show files with raw names
list.files(file.path(tempdir(),"REDS2021"))

# Rename files
ILSArename(inputdir = file.path(tempdir(),"REDS2021"))

# Show files new names 
list.files(file.path(tempdir(),"REDS2021"))

}
