% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiff_utils.R
\name{buildIFD}
\alias{buildIFD}
\title{Image Field Directory Builder}
\usage{
buildIFD(val, typ, tag, endianness = .Platform$endian)
}
\arguments{
\item{val}{the value of the IFD}

\item{typ}{desired IFD type}

\item{tag}{the desired IFD 'tag'}

\item{endianness}{the desired endian-ness ("big" or "little"). Default is .Platform$endian.\cr
Endianness describes the bytes order of data stored within the files. This parameter may not be modified.}
}
\value{
NULL or a list of 2 members:\cr
-min_content: the minimal IFD content,\cr
-add_content: the additional IFD content if 'val' converted to raw does not fit in 4 bytes.
}
\description{
Builds Image Field Directory (IFD)
}
\details{
if 'val' if of type "character", 'tag' is automatically set to 2.\cr
if 'val' is of length 0 NULL is returned.
}
\keyword{internal}
