% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractFromDAF.R
\name{ExtractFromDAF}
\alias{ExtractFromDAF}
\title{DAF File Reader}
\source{
For pnt_in_poly_algorithm, Trigonometry, is an adaptation of Jeremy VanDerWal's code \url{http://github.com/jjvanderwal/SDMTools}
}
\usage{
ExtractFromDAF(
  fileName,
  extract_features = TRUE,
  extract_images = TRUE,
  extract_offsets = TRUE,
  extract_stats = TRUE,
  endianness = .Platform$endian,
  pnt_in_poly_algorithm = 1,
  pnt_in_poly_epsilon = 1e-12,
  display_progress = TRUE,
  ...
)
}
\arguments{
\item{fileName}{path to file.}

\item{extract_features}{whether to extract features (and graphs, pops and regions) from file. Default is TRUE.}

\item{extract_images}{whether to extract images information from file. Default is TRUE.}

\item{extract_offsets}{whether to extract IFDs offsets from corresponding. Default is TRUE.\cr
See \code{\link{getOffsets}} for further details.}

\item{extract_stats}{whether to extract population statistics. Default is TRUE.}

\item{endianness}{The endian-ness ("big" or "little") of the target system for the file. Default is .Platform$endian.\cr
Endianness describes the bytes order of data stored within the files. This parameter may not be modified.}

\item{pnt_in_poly_algorithm}{algorithm used to determine if object belongs to a polygon region or not. Default is 1.\cr
Note that for the moment only 1(Trigonometry) is available.}

\item{pnt_in_poly_epsilon}{epsilon to determine if object belongs to a polygon region or not. It only applies when algorithm is 1. Default is 1e-12.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{...}{Other arguments to be passed.}
}
\value{
A named list of class `IFC_data`, whose members are:\cr
-description, a list of descriptive information,\cr
-fileName, path of fileName input,\cr
-fileName_image, path of .cif image fileName is refering to,\cr
-features, a data.frame of features,\cr
-features_def, a describing how features are defined,\cr
-graphs, a list of graphical elements found,\cr
-pops, a list describing populations found,\cr
-regions, a list describing how regions are defined,\cr
-images, a data.frame describing information about images,\cr
-offsets, an integer vector of images and masks IFDs offsets,\cr
-stats, a data.frame describing populations count and percentage to parent and total population,\cr
-checksum, checksum of .cif image fileName is refering to computed from images values found in current daf.
}
\description{
Extracts data from DAF Files.
}
\details{
When extract_features is TRUE it allows eatures, graphs, pops, regions to be extracted.\cr
If extract_features is TRUE, extract_stats will be automatically forced to TRUE.\cr
If extract_stats is TRUE, extract_features will be automatically forced to TRUE.\cr
If extract_offsets is TRUE, extract_images will be automatically forced to TRUE.\cr
If extract_images is TRUE, information about images will be extracted.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a daf file
  file_daf <- system.file("extdata", "example.daf", package = "IFCdata")
  daf <- ExtractFromDAF(fileName = file_daf)
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
