% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapperfuncs.r
\name{get.cross.K}
\alias{get.cross.K}
\title{Cross type K function using homotypic and heterotypic case types}
\usage{
get.cross.K(epi.data, type, hom, het = NULL, r = NULL,
  correction = "border")
}
\arguments{
\item{epi.data}{a three-column numerical matrix that contains coordinates (\code{x} and \code{y}) for each case and information on case type (e.g. genotype or serotype). First two columns must be \code{x} and \code{y}}

\item{type}{an integer giving the column that contains information on case type. Must be an integer or a character}

\item{hom}{a scalar or vector giving the homotypic case type(s). Equivalent to the 'j' point type used in the cross K function. Must be an integer or character}

\item{het}{a scalar or vector giving the heterotypic case type(s). Equivalent to the 'i' point type used in the cross K function. The default is \code{NULL}, which uses any case type not defined in the \code{hom} argument as heterotypic. Must be an integer or a character}

\item{r}{a numeric vector giving the spatial distances}

\item{correction}{type of edge correction to be applied (default set to simple 'border' edge correction). See the \link[spatstat]{Kcross} function in the \pkg{spatstat} package for more details}
}
\value{
a data frame with a minimum of three columns giving the radius (\code{r}), the theoretical value of the K function for a Poisson process (\code{theo}), and value of the K function evaluated at radius \code{r}. The column name gives the type of edge correction used
}
\description{
A wrapper function of the \link[spatstat]{Kcross} function from the \pkg{spatstat} package (Baddeley et al. 2016) that takes epidemiological data used by \pkg{IDSpatialStats} functions and calculates the cross type K-function based on user defined case type homology
}
\examples{
data(DengueSimR01)

k <- get.cross.K(epi.data=DengueSimR01, type=5, hom=2, het=NULL, r=NULL, correction='border')

plot(k[,2], type='l', col='red', lty=2, xlab='r', ylab='cross K function')
lines(k$border)
}
\references{
Baddeley A, Rubak E, and Turner R. (2016). "Spatial Point Patterns: Methodology and Applications with R". CRC Press.
}
\author{
John Giles
}
