% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_custom.R
\name{convert_custom}
\alias{convert_custom}
\title{Convert Identifiers with Custom Database}
\usage{
convert_custom(x, from = NULL, to = NULL, dt = NULL, multiple = FALSE)
}
\arguments{
\item{x}{A character vector to convert.}

\item{from}{Which identifier type to be converted.}

\item{to}{Identifier type convert to.}

\item{dt}{A \code{data.frame} as database for conversion.}

\item{multiple}{if \code{TRUE}, return a \code{data.table} instead of a
string vector, so multiple identifier mappings can be kept.}
}
\value{
A character vector.
}
\description{
Convert Identifiers with Custom Database
}
\examples{
dt <- data.table::data.table(UpperCase = LETTERS[1:5], LowerCase = letters[1:5])
dt
x <- convert_custom(c("B", "C", "E", "E", "FF"), from = "UpperCase", to = "LowerCase", dt = dt)
x
}
