% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screeplot.ics.R
\name{screeplot.ICS-S3}
\alias{screeplot.ICS-S3}
\alias{screeplot.ICS}
\title{Screeplot for an \code{ICS} Object}
\usage{
\method{screeplot}{ICS}(
  x,
  index = NULL,
  type = "barplot",
  main = deparse(substitute(x)),
  ylab = "generalized kurtosis",
  xlab = "component",
  names.arg = index,
  labels = TRUE,
  ...
)
}
\arguments{
\item{x}{object of class \code{ICS}}

\item{index}{index of the components to be plottes.
If NULL all components are used.}

\item{type}{"barplot" if a barplot or "lines" if a line plot is preferred.}

\item{main}{main title of the plot.}

\item{ylab}{y-axis label.}

\item{xlab}{x-axis label.}

\item{names.arg}{names.arg argument passed on to "barplot".}

\item{labels}{\code{labels} argument for the labels of the x-axis passed on to
\code{axis}.}

\item{...}{other arguments for the plotting functions.}
}
\description{
Plots the kurtosis measures of an \code{ICS} object against its index number.
Two versions of this screeplot are available.
}
\examples{
X <- iris[,-5]
out <- ICS(X)
screeplot(out)
screeplot(out, type = "lines")
}
\seealso{
\code{\link{ICS}()}

\code{\link{gen_kurtosis}()}  method
}
\author{
Andreas Alfons and Aurore Archimbaud
}
