% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{GetExomeKmerCounts}
\alias{GetExomeKmerCounts}
\title{Generate exome k-mer abundance from a given reference genome}
\usage{
GetExomeKmerCounts(k, ref.genome, exome.ranges, filter.path,
  verbose = FALSE)
}
\arguments{
\item{k}{Length of k-mers (k>=2)}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{filter.path}{If given, homopolymers will be masked from
genome(sequence). Only simple repeat masking is accepted now.}

\item{verbose}{If \code{TRUE} generate progress messages.}

\item{exome.range}{A keyed data table which has exome ranges information.
It has three columns: chrom, start and end.}
}
\value{
Matrix of the counts of exome k-mer across the \code{ref.genome}
}
\description{
Generate exome k-mer abundance from a given reference genome
}
\keyword{internal}
