% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pyramid.R
\name{plot.pyramid}
\alias{plot.pyramid}
\title{Plot an age pyramid.}
\usage{
\method{plot}{pyramid}(
  x,
  group_colors = NULL,
  group_legend = "Group",
  age_breaks = NULL,
  value_breaks = NULL,
  ...
)
}
\arguments{
\item{x}{Object of class \code{\link{pyramid}}.

\emph{(Optional)} For plotting an age pyramid composed of several subgroups, the population data frame must contain a column named \code{group_name}.}

\item{group_colors}{\emph{(Optional)} Named character vector.}

\item{group_legend}{\emph{(Optional)} Legend title name. By default set to \code{"Group"}.}

\item{age_breaks}{\emph{(Optional)} An ordered vector of indexes of vector \code{unique(pyr$age)} used for breaks for the axis of ages.}

\item{value_breaks}{\emph{(Optional)} Breaks for the axis of values.}

\item{...}{Additional parameters}
}
\value{
Plot of the age pyramid.
}
\description{
Plot an age pyramid from age pyramid data frame with possibly several characteristics.
}
\examples{
plot.pyramid(subset(pyramid(EW_pop_14$age_pyramid), as.numeric(age) <= 110))

\donttest{
library(colorspace)
pyr_IMD <- subset(pyramid(EW_popIMD_14$age_pyramid), as.numeric(age) <= 110)
pyr_IMD$group_name <- with(pyr_IMD, ifelse(male, paste('Males - IMD', IMD),
                          paste('Females - IMD', IMD)))
colors <- c(sequential_hcl(n=5, palette = "Magenta"),
            sequential_hcl(n=5, palette = "Teal"))
names(colors) <- c(paste('Females - IMD', 1:5),
                   paste('Males - IMD', 1:5))
# note that you must have setequal(names(colors), pyr_IMD$group_name) is TRUE
plot.pyramid(pyr_IMD, colors)

# age pyramids at different times
library(gganimate)
pyrs = age_pyramids(population(EW_popIMD_14$sample), time = 1:10)
plot.pyramid(pyrs) + transition_time(time) + labs(title = "Time: {frame_time}")
}
}
\seealso{
\code{\link{plot.population}}
}
