% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{death_table}
\alias{death_table}
\title{Creates a death table.}
\usage{
death_table(population, ages, period)
}
\arguments{
\item{population}{Population data frame containing at least \code{'birth'} and \code{'death'} columns.}

\item{ages}{A vector of size \code{N} composed of age groups.
The function computes the number of death  in each age group \code{[ages[i],ages[i+1])}, for \code{i=1..N-1}.}

\item{period}{A vector of size \code{M} composed of time intervals.}
}
\value{
A death table matrix.
}
\description{
Creates a death table from a population data frame.
For each \code{i=1..N-1} and \code{j=1..M}, the number of individuals with age at last birthday in \code{[ages[i],ages[i+1])} and died in \code{[times[j],times[j+1])} is computed.
}
\details{
The function computes the number of death in each time interval \code{[times[j],times[j+1])}, \code{j=1..M}.
}
\examples{
dth_table <- death_table(EW_pop_out, 0:101, 0:31)

}
