% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPolicyValues.R
\name{setPolicyValues}
\alias{setPolicyValues}
\title{Assign Default Policy Values}
\usage{
setPolicyValues(network, ...)
}
\arguments{
\item{network}{A Hyde Network object}

\item{...}{arguments named for nodes in the network.  The value of each
argument will be assigned to the \code{nodePolicyValues} element of 
the \code{HydeNetwork} object.}
}
\description{
By default, \code{HydeNet} uses factor levels for policy
  values in a decision node, assuming the decision node is a factor 
  variable. In cases where the decision node is a numeric variable, 
  \code{HydeNet} will first try to assign the first, second, and 
  third quartiles as policy values.  \code{setPolicyValues} allows 
  the user flexibility in which values are actually used in the 
  decision network.  It can also be used to restrict the levels of 
  a factor variable to a subset of all levels.  Policy values may also 
  be set in \code{setNode}, but \code{setPolicyValues} makes it possible
  to set the values for multiple nodes in one call.
}
\author{
Jarrod Dalton and Benjamin Nutter
}

