% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_distributionH.R
\name{kurtH}
\alias{kurtH}
\alias{kurtH,distributionH-method}
\title{Method \code{kurtH}: computes the kurthosis of a distribution}
\usage{
kurtH(object)

\S4method{kurtH}{distributionH}(object)
}
\arguments{
\item{object}{a \code{distributionH} object}
}
\value{
A value for the kurtosis index, 3 is the kurtosis of a Gaussian
distribution
}
\description{
Kurtosis of a histogram (using the fourth standardized moment)
}
\examples{

## ---- A mydist distribution ----
mydist <- distributionH(x = c(1, 2, 3, 10), p = c(0, 0.1, 0.5, 1))
## ---- Compute the kurtosis of mydist ----
kurtH(mydist) #---> 1.473242
}
\author{
Antonio Irpino
}
\keyword{distribution}
