% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_distributionH.R
\docType{methods}
\name{plot-distributionH}
\alias{plot-distributionH}
\alias{plot,distributionH-method}
\title{plot for a distributionH object}
\usage{
\S4method{plot}{distributionH}(x, type = "HISTO", col = "green", border = "black")
}
\arguments{
\item{x}{a \code{distributionH} object}

\item{type}{(optional) a string describing the type of plot, default="HISTO".\cr Other allowed types are
\cr"CDF"=Cumulative distribution function, \cr"QF"= quantile function, \cr"DENS"=a density approximation,
\cr"HBOXPLOT"=horizontal boxplot, \cr"VBOXPLOT"= vertical boxplot,}

\item{col}{(optional) a string the color of the plot, default="green".}

\item{border}{(optional) a string the color of the border of the plot, default="black".}
}
\description{
A plot function for a \code{distributionH} object. The function returns a representation
of the histogram.
}
\examples{
## ---- initialize a distributionH
mydist <- distributionH(x = c(7, 8, 10, 15), p = c(0, 0.2, 0.7, 1))
# show the histogram
plot(mydist) # plots mydist
plot(mydist, type = "HISTO", col = "red", border = "blue") # plots mydist
plot(mydist, type = "DENS", col = "red", border = "blue") # plots a density approximation for mydist
plot(mydist, type = "HBOXPLOT") # plots a horizontal boxplot for mydist
plot(mydist, type = "VBOXPLOT") # plots a vertical boxplot for mydist
plot(mydist, type = "CDF") # plots the cumulative distribution function of mydist
plot(mydist, type = "QF") # plots the quantile function of mydist
}
