% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGMPF.R
\name{GGMPF}
\alias{GGMPF}
\title{GGM-based heterogeneity analysis.}
\usage{
GGMPF(lambda, data, K, initial.selection="K-means",
             initialize, average=FALSE, asymmetric=TRUE,
             eps = 5e-2, maxiter=10, maxiter.AMA=5, local_appro=TRUE,
             trace = FALSE, penalty = "MCP", theta.fusion=TRUE)
}
\arguments{
\item{lambda}{A list, the sequences of the tuning parameters (lambda1, lambda2, and lambda3).}

\item{data}{n * p matrix, the design matrix.}

\item{K}{Int, a selected upper bound of K_0.}

\item{initial.selection}{The different initial values from two clustering methods, which can be selected from c("K-means","dbscan").}

\item{initialize}{A given initial values, which should be given when initial.selection is not in c("K-means","dbscan").}

\item{average}{The logical variable, whether to use averaging when integrating parameters that are identified as identical subgroups, the default setting is F, which means the estimated parameters for the subgroup with the largest sample size among the subgroups identified as identical subgroups is used as the final parameter for this subgroup.}

\item{asymmetric}{The logical variable, symmetry of the precision matrices or not, the default setting is T.}

\item{eps}{A float value, algorithm termination threshold.}

\item{maxiter}{Int, maximum number of cycles of the ADMM algorithm.}

\item{maxiter.AMA}{Int, maximum number of cycles of the AMA algorithm.}

\item{local_appro}{The logical variable, whether to use local approximations when updating mean parameters, the default setting is T.}

\item{trace}{The logical variable, whether or not to output the number of identified subgroups during the search for parameters.}

\item{penalty}{The type of the penalty, which can be selected from c("MCP", "SCAD", "lasso").}

\item{theta.fusion}{Whether or not the fusion penalty term contains elements of the precision matrices. The default setting is T.}
}
\value{
A list including all estimated parameters and the BIC values with all choices of given tuning parameters, and the selected optional parameters.
}
\description{
The main function of Gaussian graphical model-based heterogeneity analysis via penalized fusion.
}
\references{
Ren, M., Zhang S., Zhang Q. and Ma S. (2020). Gaussian Graphical Model-based Heterogeneity Analysis via Penalized Fusion. Biometrics, Published Online, https://doi.org/10.1111/biom.13426.
}
\author{
Mingyang Ren, Sanguo Zhang, Qingzhao Zhang, Shuangge Ma. Maintainer: Mingyang Ren <renmingyang17@mails.ucas.ac.cn>.
}
