% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tide.info.R
\name{tide.info}
\alias{tide.info}
\title{Annual tide calendar for one particular location}
\usage{
tide.info(location = NULL, year = 2021, longitude = NULL, latitude = NULL)
}
\arguments{
\item{location}{Textual information}

\item{year}{Year to get the calendar}

\item{longitude}{Longitude to search for}

\item{latitude}{Latitude to search for}
}
\value{
Return a data.frame with annual tide calendar.
}
\description{
Annual tide information.\cr
The columns are: Location, Longitude, Latitude, Phase, DateTime.local, DateTime.UTC, Tide.meter\cr
This function uses an API linking xtide software 
(https://flaterco.com/xtide/) with tide.info() function.\cr
You must have a working internet connection for this function.
}
\details{
tide.info gets the annual tide calendar for one particular location.
}
\examples{
\dontrun{
library("HelpersMG")
Location <- "Les Hattes"
Year <- 2010
tide <- tide.info(Location, Year)
plot(tide[, "DateTime.local"], tide[, "Tide.meter"], 
     type="l", bty="n", las=1, 
     main=tide[1, "Location"], 
     xlab=as.character(Year), ylab="Tide level in meter")

Location <- "Hawaii"
Year <- 2010
tide <- tide.info(Location, Year)

Location <- "Hanamaulu Bay, Kauai Island, Hawaii"
Year <- 2010
tide <- tide.info(Location, Year)
plot(tide[, "DateTime.local"], tide[, "Tide.meter"], 
     type="l", bty="n", las=1, 
     main=tide[1, "Location"], 
     xlab=as.character(Year), ylab="Tide level in meter")
     
tide <- tide.info(year=2010, longitude=-32, latitude=-4)
library(maps)
map(database = "world", regions = "Brazil", asp=1, 
    xlim=c(-80, -30), ylim=c(-33, 5))
points(tide[1, "Longitude"], tide[1, "Latitude"], col="red")
points(-32, -4, col="blue")
axis(1)
axis(2, las=1)
     
# Show the locations with data    
library(maps)
map()
axis(1)
axis(2, las=1)
points(tide_location[, c("longitude")], tide_location[, c("latitude")], 
       pch=".", col="red", cex=2)
}
}
\seealso{
Other Periodic patterns of indices: 
\code{\link{index.periodic}()},
\code{\link{minmax.periodic}()},
\code{\link{moon.info}()},
\code{\link{sun.info}()}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\concept{Periodic patterns of indices}
\keyword{Tide}
