% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JohnsonFit.R
\name{pJohnson}
\alias{pJohnson}
\alias{JohnsonFit}
\title{The Johnson distributions}
\usage{
pJohnson(q, parms, lower.tail = TRUE, log.p = FALSE)

JohnsonFit(t, moment = "quant")
}
\arguments{
\item{q}{vector of quantities.}

\item{parms}{list or list of lists each containing output of \code{JohnsonFit}.}

\item{lower.tail}{logical vector; if TRUE (default), probabilities are \eqn{P[X <= x]},
otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical vector; if TRUE, probabilities p are given as log(p).}

\item{t}{observation vector, t=x.}

\item{moment}{character scalar specifying t: for now only "quant".}
}
\value{
\code{pJohnson()} gives the distribution function.
  \code{JohnsonFit()} outputs a list containing the Johnson parameters
  (gamma, delta, xi, lambda, type), where type is one of the Johnson types: "SN", "SL",
  "SB", or "SU". \code{JohnsonFit()} does this using 5 order statistics when
  moment="quant".
}
\description{
Density of the Johnson distribution; adapted from the orphaned SuppDists package.
}
\details{
The Johnson system (Johnson 1949) is a very flexible system for describing statistical
	 distributions. It is defined by
	 \deqn{z=\gamma+\delta \log{f(u)}, u=(x-\xi)/\lambda}{z=gamma+delta log(f(u)), with u=(x-xi)/lambda}
  and where \eqn{f( )} has four possible forms:
  \tabular{ll}{
  	SL:\tab \eqn{f(u)=u} the log normal \cr
  	SU:\tab \eqn{f(u)=u+\sqrt{1+u^2}}{f(u)=u+sqrt(1+u^2)} an unbounded distribution\cr
  	SB:\tab \eqn{f(u)=u/(1-u)} a bounded distribution\cr
  	SN:\tab \eqn{\exp(u)} the normal
  }
  Estimation of the Johnson parameters may be done from quantiles. The procedure of
   Wheeler (1980) is used. They may also be estimated from the moments.
   Applied Statistics algorithm 99, due to Hill, Hill, and Holder (1976) has been
   translated into C for this implementation.
}
\references{
Hill, I.D., Hill, R., and Holder, R.L. (1976). Fitting Johnson curves
   by moments. \emph{Applied Statistics.} AS99;
 Johnson, N.L. (1949). Systems of frequency curves generated by methods of translation.
   \emph{Biometrika,} \bold{36.} 149-176;
 Wheeler, R.E. (1980). Quantile estimators of Johnson curve parameters. \emph{Biometrika.}
   \bold{67-3} 725-728
}
\author{
Bob Wheeler
}
\keyword{internal}
