% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BD_ordinations.R
\name{phyloseq_list_ord_dfs}
\alias{phyloseq_list_ord_dfs}
\title{Converting ordination objects to data.frames}
\usage{
phyloseq_list_ord_dfs(physeq_l, physeq_l_ords, parallel = FALSE)
}
\arguments{
\item{physeq_l}{A list of phyloseq objects}

\item{physeq_l_ords}{A list of ordination objects}

\item{parallel}{Parallel processing. See \code{plyr::adply} for more information.}
}
\value{
List of data.frame objects
}
\description{
For each ordination object in a list, converts to a data.frame
for easy plotting with ggplot
}
\examples{
data(physeq_S2D2_l)
\dontrun{
# make a list of beta diversity distance matrix objects
physeq_S2D2_l_d = physeq_list_betaDiv(physeq_S2D2_l)
# make a list of ordinations
physeq_S2D2_l_d_ord = physeq_list_ord(physeq_S2D2_l, physeq_S2D2_l_d)
# convert ordination information to data.frame objects
physeq_S2D2_l_d_ord_df = phyloseq_list_ord_dfs(physeq_S2D2_l, physeq_S2D2_l_d_ord)
}

}
