% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeR2.R
\name{computeR2}
\alias{computeR2}
\alias{mypredict}
\title{Compute variance explained by models}
\usage{
mypredict(model, newdata)

computeR2(pred, outcome, usebinary = 1)
}
\arguments{
\item{model}{a fitted model, which is the output of \code{themodel}.}

\item{newdata}{a data frame which contains all the variables included in the model.
This data frame is used to make prediction on.}

\item{pred}{a vector of the predicted outcome.}

\item{outcome}{a vector of the actual outcome.}

\item{usebinary}{a non-negative number representing different models.
Use linear model if \code{usebinary=0},
use logistic regression model via \code{fastglm} if \code{usebinary=1} (by default),
and use logistic regression model via \code{glm} if \code{usebinary>1}.}
}
\value{
\code{mypredict} returns a vector of the predicted outcome.

\code{computeR2} returns a positive number of the variance explained by the
linear model (conventional \ifelse{html}{\out{R<sup>2</sup>}}{\eqn{R^2}}) or
the generalized linear model (McFadden's \ifelse{html}{\out{R<sup>2</sup>}}{\eqn{R^2}}).
}
\description{
Compute the variance explained by a linear or
generalized linear model.
}
\details{
The variance explained by a linear model is based on the conventional \ifelse{html}{\out{R<sup>2</sup>}}{\eqn{R^2}}.
As for logistic regression, we use McFadden's \ifelse{html}{\out{R<sup>2</sup>}}{\eqn{R^2}}.
}
\examples{
## create datasets
x=matrix(runif(100,-2,2),ncol=5)
outcome=(0.5*x[,2] - 0.8*x[,4] + 0.3*x[,5])>runif(100,-2,2)

## create binary outcome
outcome[outcome]=1
data=data.frame(outcome,x)

## compute the variance explained by features
model=themodel(outcome~.,data[1:80,],usebinary=1)
outcome_predict=mypredict(model,data[81:100,])
computeR2(outcome_predict,data[81:100,'outcome'],usebinary=1)
}
\references{
McFadden, Daniel. "Conditional logit analysis of qualitative choice behavior." (1973).
}
