/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import ptolemy.plot.PlotBox;

public class PlotBoxMLParser
extends HandlerBase {
    public static String PlotML_DTD_1 = "<!ELEMENT plot (barGraph | bin | dataset | default | noColor | noGrid | size | title | wrap | xLabel | xLog | xRange | xTicks | yLabel | yLog | yRange | yTicks)*><!ELEMENT barGraph EMPTY><!ATTLIST barGraph width CDATA #IMPLIED offset CDATA #IMPLIED><!ELEMENT bin EMPTY><!ATTLIST bin width CDATA #IMPLIED offset CDATA #IMPLIED><!ELEMENT dataset (m | move | p | point)*><!ATTLIST dataset connected (yes | no) #IMPLIED marks (none | dots | points | various) #IMPLIED name CDATA #IMPLIED stems (yes | no) #IMPLIED><!ELEMENT default EMPTY><!ATTLIST default connected (yes | no) \"yes\" marks (none | dots | points | various) \"none\" stems (yes | no) \"no\"><!ELEMENT noColor EMPTY><!ELEMENT noGrid EMPTY><!ELEMENT reuseDatasets EMPTY><!ELEMENT size EMPTY><!ATTLIST size height CDATA #REQUIRED width CDATA #REQUIRED><!ELEMENT title (#PCDATA)><!ELEMENT wrap EMPTY><!ELEMENT xLabel (#PCDATA)><!ELEMENT xLog EMPTY><!ELEMENT xRange EMPTY><!ATTLIST xRange min CDATA #REQUIRED max CDATA #REQUIRED><!ELEMENT xTicks (tick)+><!ELEMENT yLabel (#PCDATA)><!ELEMENT yLog EMPTY><!ELEMENT yRange EMPTY><!ATTLIST yRange min CDATA #REQUIRED max CDATA #REQUIRED><!ELEMENT yTicks (tick)+><!ELEMENT tick EMPTY><!ATTLIST tick label CDATA #REQUIRED position CDATA #REQUIRED><!ELEMENT m EMPTY><!ATTLIST m x CDATA #IMPLIED y CDATA #REQUIRED lowErrorBar CDATA #IMPLIED highErrorBar CDATA #IMPLIED><!ELEMENT move EMPTY><!ATTLIST move x CDATA #IMPLIED y CDATA #REQUIRED lowErrorBar CDATA #IMPLIED highErrorBar CDATA #IMPLIED><!ELEMENT p EMPTY><!ATTLIST p x CDATA #IMPLIED y CDATA #REQUIRED lowErrorBar CDATA #IMPLIED highErrorBar CDATA #IMPLIED><!ELEMENT point EMPTY><!ATTLIST point x CDATA #IMPLIED y CDATA #REQUIRED lowErrorBar CDATA #IMPLIED highErrorBar CDATA #IMPLIED>";
    protected Hashtable _attributes;
    protected StringBuffer _currentCharData = new StringBuffer();
    protected XmlParser _parser = new XmlParser();
    protected PlotBox _plot;
    private URL _base;
    private Stack _externalEntities = new Stack();
    private boolean _xtick;

    public PlotBoxMLParser(PlotBox plotBox) {
        this._plot = plotBox;
    }

    protected PlotBoxMLParser() {
    }

    public void attribute(String string, String string2, boolean bl) throws XmlException {
        if (string == null) {
            throw new XmlException("Attribute has no name", this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
        if (string2 != null) {
            this._attributes.put(string, string2);
        }
    }

    public void charData(char[] cArray, int n, int n2) {
        this._currentCharData.append(cArray, n, n2);
    }

    public void endDocument() throws Exception {
    }

    public void endElement(String string) throws Exception {
        if (string.equals("noGrid")) {
            this._plot.setGrid(false);
        } else if (string.equals("noColor")) {
            this._plot.setColor(false);
        } else if (string.equals("title")) {
            this._plot.setTitle(this._currentCharData.toString());
        } else if (string.equals("wrap")) {
            this._plot.setWrap(true);
        } else if (string.equals("xLabel")) {
            this._plot.setXLabel(this._currentCharData.toString());
        } else if (string.equals("xLog")) {
            this._plot.setXLog(true);
        } else if (string.equals("yLabel")) {
            this._plot.setYLabel(this._currentCharData.toString());
        } else if (string.equals("yLog")) {
            this._plot.setYLog(true);
        }
    }

    public void error(String string, String string2, int n, int n2) throws XmlException {
        throw new XmlException(string, this._currentExternalEntity(), n, n2);
    }

    public void parse(URL uRL, InputStream inputStream) throws Exception {
        this.parse(uRL, new InputStreamReader(inputStream));
    }

    public void parse(URL uRL, Reader reader) throws Exception {
        this._parser.setHandler(this);
        this._base = uRL;
        BufferedReader bufferedReader = new BufferedReader(reader);
        if (uRL == null) {
            this._parser.parse(null, null, bufferedReader);
        } else {
            this._parser.parse(uRL.toExternalForm(), null, bufferedReader);
        }
    }

    public void parse(URL uRL, String string) throws Exception {
        this.parse(uRL, new StringReader(string));
    }

    public Object resolveEntity(String string, String string2) {
        if (string != null && string.equals("-//UC Berkeley//DTD PlotML 1//EN")) {
            return new StringReader(PlotML_DTD_1);
        }
        return null;
    }

    public void startDocument() {
        this._attributes = new Hashtable();
    }

    public void startElement(String string) throws XmlException {
        try {
            if (string.equals("size")) {
                String string2 = (String)this._attributes.get("height");
                this._checkForNull(string2, "No height argument for element \"size\"");
                int n = Integer.valueOf(string2);
                string2 = (String)this._attributes.get("width");
                this._checkForNull(string2, "No width argument for element \"size\"");
                int n2 = Integer.valueOf(string2);
                this._plot.setSize(n2, n);
            } else if (string.equals("tick")) {
                String string3 = (String)this._attributes.get("label");
                this._checkForNull(string3, "No label for element \"tick\"");
                String string4 = (String)this._attributes.get("position");
                this._checkForNull(string4, "No position for element \"tick\"");
                double d = Double.valueOf(string4);
                if (this._xtick) {
                    this._plot.addXTick(string3, d);
                } else {
                    this._plot.addYTick(string3, d);
                }
            } else if (string.equals("title")) {
                this._currentCharData = new StringBuffer();
            } else if (string.equals("xLabel")) {
                this._currentCharData = new StringBuffer();
            } else if (string.equals("xRange")) {
                String string5 = (String)this._attributes.get("min");
                this._checkForNull(string5, "No min argument for element \"xRange\"");
                double d = Double.valueOf(string5);
                string5 = (String)this._attributes.get("max");
                this._checkForNull(string5, "No max argument for element \"xRange\"");
                double d2 = Double.valueOf(string5);
                this._plot.setXRange(d, d2);
            } else if (string.equals("xTicks")) {
                this._xtick = true;
            } else if (string.equals("yLabel")) {
                this._currentCharData = new StringBuffer();
            } else if (string.equals("yRange")) {
                String string6 = (String)this._attributes.get("min");
                this._checkForNull(string6, "No min argument for element \"yRange\"");
                double d = Double.valueOf(string6);
                string6 = (String)this._attributes.get("max");
                this._checkForNull(string6, "No max argument for element \"yRange\"");
                double d3 = Double.valueOf(string6);
                this._plot.setYRange(d, d3);
            } else if (string.equals("yTicks")) {
                this._xtick = false;
            }
        }
        catch (Exception exception) {
            if (exception instanceof XmlException) {
                throw (XmlException)exception;
            }
            String string7 = "XML element \"" + string + "\" triggers exception:\n  " + exception.toString();
            throw new XmlException(string7, this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
        this._attributes.clear();
    }

    public void startExternalEntity(String string) {
        this._externalEntities.push(string);
    }

    protected void _checkForNull(Object object, String string) throws XmlException {
        if (object == null) {
            throw new XmlException(string, this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
    }

    protected String _currentExternalEntity() {
        return (String)this._externalEntities.peek();
    }
}

