/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.util;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.OutputProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XSLTUtilities {
    private XSLTUtilities() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 3) {
            System.err.println("Usage: java -classpath $PTII ptolemy.util.XSLTUtilities inputFile xslFile1 [xslFile2 . . .] outputFile");
            System.exit(2);
        }
        FileWriter fileWriter = new FileWriter(stringArray[stringArray.length - 1]);
        Document document = XSLTUtilities.parse(stringArray[0]);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 1; i < stringArray.length - 1; ++i) {
            linkedList.add(stringArray[i]);
        }
        Document document2 = XSLTUtilities.transform(document, linkedList);
        fileWriter.write(XSLTUtilities.toString(document2));
        fileWriter.close();
    }

    public static Document parse(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(new InputSource(string));
    }

    public static String toString(Document document) throws Exception {
        Properties properties = OutputProperties.getDefaultMethodProperties((String)"xml");
        properties.setProperty("indent", "yes");
        properties.setProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Serializer serializer = SerializerFactory.getSerializer((Properties)properties);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        serializer.setOutputStream((OutputStream)byteArrayOutputStream);
        serializer.asDOMSerializer().serialize((Node)document);
        ((OutputStream)byteArrayOutputStream).close();
        return ((Object)byteArrayOutputStream).toString();
    }

    public static Document transform(Document document, String string) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer(new StreamSource(string));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            try {
                Class<?> clazz = Class.forName("ptolemy.util.XSLTUtilities");
                URL uRL = clazz.getClassLoader().getResource(string);
                if (uRL == null) {
                    throw transformerConfigurationException;
                }
                transformer = transformerFactory.newTransformer(new StreamSource(uRL.toString()));
            }
            catch (Exception exception) {
                throw transformerConfigurationException;
            }
        }
        DOMResult dOMResult = new DOMResult();
        transformer.transform(new DOMSource(document), dOMResult);
        return (Document)dOMResult.getNode();
    }

    public static Document transform(Document document, List list) throws Exception {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            document = XSLTUtilities.transform(document, string);
        }
        return document;
    }

    public static void transform(String string, String string2, String string3) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string3);
        StreamSource streamSource = new StreamSource(string2);
        StreamResult streamResult = new StreamResult(fileOutputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(string));
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(streamSource, streamResult);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }
}

