/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFrame;

public class PlotApplication
extends PlotFrame {
    protected static boolean _test = false;

    public PlotApplication() throws Exception {
        this(new String[0]);
    }

    public PlotApplication(String[] stringArray) throws Exception {
        this(new Plot(), stringArray);
    }

    public PlotApplication(PlotBox plotBox, String[] stringArray) throws Exception {
        super("PlotApplication", plotBox);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._parseArgs(stringArray);
        if (stringArray == null || stringArray.length == 0) {
            this.samplePlot();
        }
        this.setVisible(true);
    }

    public PlotApplication(PlotBox plotBox) {
        super("PlotApplication", plotBox);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            new PlotApplication(new Plot(), stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        if (_test) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "PlotApplication class\nBy: Edward A. Lee, eal@eecs.berkeley.edu and Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 5.3, Build: $Id: PlotApplication.java,v 1.45 2003/04/29 03:08:22 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-2003, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    protected void _close() {
        System.exit(0);
    }

    protected void _help() {
        JOptionPane.showMessageDialog(this, "PlotApplication is a standalone plot  application.\n  File formats understood: Ptplot ASCII.\n  Left mouse button: Zooming.\n\n" + this._usage(), "About Ptolemy Plot", 1);
    }

    protected int _parseArgs(String[] stringArray) throws CmdLineArgException, FileNotFoundException, IOException {
        int n = 0;
        String string = "Ptolemy plot";
        int n2 = 500;
        int n3 = 300;
        while (stringArray != null && n < stringArray.length) {
            Object object;
            String string2;
            if ((string2 = stringArray[n++]).equals("-height")) {
                if (n > stringArray.length - 1) {
                    throw new CmdLineArgException(this._usage());
                }
                n3 = Integer.valueOf(stringArray[n++]);
                continue;
            }
            if (string2.equals("-help")) {
                System.out.println(this._usage());
                System.exit(0);
                continue;
            }
            if (string2.equals("-test")) {
                _test = true;
                continue;
            }
            if (string2.equals("-version")) {
                System.out.println("Version 5.3, Build $Id: PlotApplication.java,v 1.45 2003/04/29 03:08:22 cxh Exp $");
                System.exit(0);
                continue;
            }
            if (string2.equals("-width")) {
                if (n > stringArray.length - 1) {
                    throw new CmdLineArgException("-width requires an integer argument");
                }
                n2 = Integer.valueOf(stringArray[n++]);
                continue;
            }
            if (string2.equals("")) continue;
            if (string2.equals("-")) {
                object = new URL("file", null, "standard input");
                this._read((URL)object, System.in);
                continue;
            }
            if (!string2.startsWith("-")) {
                URL uRL;
                try {
                    URL uRL2;
                    uRL = uRL2 = new URL(null, string2);
                    object = uRL2.openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(string2);
                    object = new FileInputStream(file);
                    this._file = new File(file.getAbsolutePath());
                    string = this._file.getName();
                    this._directory = this._file.getParentFile();
                    uRL = new URL("file", null, this._directory.getAbsolutePath());
                }
                this._read(uRL, (InputStream)object);
                continue;
            }
            throw new CmdLineArgException("Unrecognized option: " + string2);
        }
        this.setSize(n2, n3);
        this.setTitle(string);
        int n4 = n;
        return n4;
    }

    protected String _usage() {
        int n;
        String[][] stringArrayArray = new String[][]{{"-height", "<pixels>"}, {"-width", "<pixels>"}};
        String[] stringArray = new String[]{"-help", "-test", "-version", "-"};
        String string = "Usage: ptplot [ options ] [file ...]\n\nOptions that take values:\n";
        for (n = 0; n < stringArrayArray.length; ++n) {
            string = string + " " + stringArrayArray[n][0] + " " + stringArrayArray[n][1] + "\n";
        }
        string = string + "\nBoolean flags:\n";
        for (n = 0; n < stringArray.length; ++n) {
            string = string + " " + stringArray[n];
        }
        return string;
    }
}

