/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import ptolemy.gui.MessageHandler;
import ptolemy.gui.ShellInterpreter;

public class ShellTextArea
extends JPanel {
    public String mainPrompt = ">> ";
    public String contPrompt = "";
    public int historyLength = 20;
    private StringBuffer _commandBuffer = new StringBuffer();
    private JTextArea _jTextArea;
    private int _promptCursor = 0;
    private int _historyCursor = 0;
    private Vector _historyCommands = new Vector();
    private String _initialMessage = null;
    private ShellInterpreter _interpreter;

    public ShellTextArea() {
        this((String)null);
    }

    public ShellTextArea(String string) {
        super(new BorderLayout());
        this._initialMessage = string;
        this._jTextArea = new JTextArea("", 20, 80);
        JScrollPane jScrollPane = new JScrollPane(this._jTextArea);
        this.add(jScrollPane);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), ""));
        this._jTextArea.addKeyListener(new ShellKeyListener());
    }

    public void addNotify() {
        super.addNotify();
        this.initialize(this._initialMessage);
    }

    public void appendJTextArea(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                ShellTextArea.this._jTextArea.append(string);
                ShellTextArea.this._jTextArea.setCaretPosition(ShellTextArea.this._jTextArea.getText().length());
                ShellTextArea.this._promptCursor += string.length();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public ShellInterpreter getInterpreter() {
        return this._interpreter;
    }

    public void clearJTextArea() {
        Runnable runnable = new Runnable(){

            public void run() {
                ShellTextArea.this._jTextArea.setText("");
                ShellTextArea.this._jTextArea.setCaretPosition(0);
                ShellTextArea.this._promptCursor = 0;
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void initialize(String string) {
        if (this._jTextArea == null) {
            this._initialMessage = string;
        } else {
            this._initialMessage = null;
            this.clearJTextArea();
            if (string != null && !string.equals("")) {
                this.appendJTextArea(string + "\n" + this.mainPrompt);
            } else {
                this.appendJTextArea(this.mainPrompt);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("ShellTextArea Example");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        jFrame.addWindowListener(windowAdapter);
        ShellTextArea shellTextArea = new ShellTextArea();
        jFrame.getContentPane().add(shellTextArea);
        jFrame.pack();
        jFrame.show();
    }

    public void replaceRangeJTextArea(final String string, final int n, final int n2) {
        Runnable runnable = new Runnable(){

            public void run() {
                ShellTextArea.this._jTextArea.replaceRange(string, n, n2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void returnResult(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                ShellTextArea.this.setEditable(true);
                String string2 = string + "\n" + ShellTextArea.this.mainPrompt;
                ShellTextArea.this.appendJTextArea(string2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setEditable(boolean bl) {
        this._jTextArea.setEditable(bl);
    }

    public void setInterpreter(ShellInterpreter shellInterpreter) {
        this._interpreter = shellInterpreter;
    }

    private void _evalCommand() {
        String string = this._jTextArea.getText().substring(this._promptCursor);
        this._promptCursor += string.length();
        if (this._commandBuffer.length() > 0) {
            this._commandBuffer.append("\n");
        }
        this._commandBuffer.append(string);
        String string2 = this._commandBuffer.toString();
        if (this._interpreter == null) {
            this.appendJTextArea("\n" + this.mainPrompt);
        } else if (this._interpreter.isCommandComplete(string2)) {
            String string3;
            this.appendJTextArea("\n");
            Cursor cursor = this._jTextArea.getCursor();
            this._jTextArea.setCursor(new Cursor(3));
            try {
                string3 = this._interpreter.evaluateCommand(string2);
            }
            catch (RuntimeException runtimeException) {
                MessageHandler.error("Failed to evaluate expression", runtimeException);
                String string4 = "Internal error evaluating expression.";
                throw runtimeException;
            }
            catch (Exception exception) {
                string3 = exception.getMessage();
            }
            if (string3 != null) {
                if (string3.trim().equals("")) {
                    this.appendJTextArea(this.mainPrompt);
                } else {
                    this.appendJTextArea(string3 + "\n" + this.mainPrompt);
                }
            } else {
                this.setEditable(false);
            }
            this._commandBuffer.setLength(0);
            this._jTextArea.setCursor(cursor);
            this._updateHistory(string2);
        } else {
            this.appendJTextArea("\n" + this.contPrompt);
        }
    }

    private void _nextCommand() {
        String string;
        if (this._historyCursor == 0) {
            string = "";
        } else {
            --this._historyCursor;
            string = (String)this._historyCommands.elementAt(this._historyCommands.size() - this._historyCursor - 1);
        }
        this.replaceRangeJTextArea(string, this._promptCursor, this._jTextArea.getText().length());
    }

    private void _previousCommand() {
        if (this._historyCursor == this._historyCommands.size()) {
            return;
        }
        ++this._historyCursor;
        String string = (String)this._historyCommands.elementAt(this._historyCommands.size() - this._historyCursor);
        this.replaceRangeJTextArea(string, this._promptCursor, this._jTextArea.getText().length());
    }

    private void _updateHistory(String string) {
        this._historyCursor = 0;
        if (this._historyCommands.size() == this.historyLength) {
            this._historyCommands.removeElementAt(0);
        }
        this._historyCommands.addElement(string);
    }

    private class ShellKeyListener
    extends KeyAdapter {
        private ShellKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 0: {
                    if (keyEvent.getKeyChar() != '\b' || ShellTextArea.this._jTextArea.getCaretPosition() != ShellTextArea.this._promptCursor) break;
                    keyEvent.consume();
                    break;
                }
                case 8: {
                    if (ShellTextArea.this._jTextArea.getCaretPosition() != ShellTextArea.this._promptCursor) break;
                    keyEvent.consume();
                    break;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 8: {
                    if (ShellTextArea.this._jTextArea.getCaretPosition() != ShellTextArea.this._promptCursor) break;
                    keyEvent.consume();
                    break;
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!ShellTextArea.this._jTextArea.isEditable()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            block0 : switch (keyEvent.getKeyCode()) {
                case 10: {
                    keyEvent.consume();
                    ShellTextArea.this._evalCommand();
                    break;
                }
                case 8: {
                    if (ShellTextArea.this._jTextArea.getCaretPosition() > ShellTextArea.this._promptCursor) break;
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    if (ShellTextArea.this._jTextArea.getCaretPosition() != ShellTextArea.this._promptCursor) break;
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    ShellTextArea.this._previousCommand();
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    ShellTextArea.this._nextCommand();
                    keyEvent.consume();
                    break;
                }
                case 36: {
                    ShellTextArea.this._jTextArea.setCaretPosition(ShellTextArea.this._promptCursor);
                    keyEvent.consume();
                    break;
                }
                default: {
                    switch (keyEvent.getModifiers()) {
                        case 2: {
                            switch (keyEvent.getKeyCode()) {
                                case 65: {
                                    ShellTextArea.this._jTextArea.setCaretPosition(ShellTextArea.this._promptCursor);
                                    keyEvent.consume();
                                    break block0;
                                }
                                case 78: {
                                    ShellTextArea.this._nextCommand();
                                    keyEvent.consume();
                                    break block0;
                                }
                                case 80: {
                                    ShellTextArea.this._previousCommand();
                                    keyEvent.consume();
                                    break block0;
                                }
                            }
                            break block0;
                        }
                    }
                }
            }
        }
    }
}

