% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SolveHMME.R
\name{SolveHMME}
\alias{SolveHMME}
\title{Solve Henderson's Mixed Model Equation.}
\usage{
SolveHMME(X, Y, Mu, Lambda)
}
\arguments{
\item{X}{an \eqn{(nm\times p)} design matrix for \eqn{\beta}.}

\item{Y}{a length-\eqn{nm} vector of observations.}

\item{Mu}{a length-\eqn{nm} vector of initial values for \eqn{\mu_i = E(Y_i)}.}

\item{Lambda}{a length-\eqn{n} vector of initial values for \eqn{\lambda}, variance of \eqn{v_i \sim N(0,\lambda_i)}}
}
\value{
a named list containing \describe{
\item{beta}{a length-\eqn{p} vector of BLUE \eqn{\hat{beta}}.}
\item{v}{a length-\eqn{n} vector of BLUP \eqn{\hat{v}}.}
\item{leverage}{a length-\eqn{(mn+n)} vector of leverages.}
}
}
\description{
Consider a linear mixed model with normal random effects,
\deqn{Y_{ij} = X_{ij}^T\beta + v_i + \epsilon_{ij}}
where \eqn{i=1,\ldots,n,\quad j=1,\ldots,m}, or it can be equivalently expressed using matrix notation,
\deqn{Y = X\beta + Zv + \epsilon}
where \eqn{Y\in \mathrm{R}^{nm}} is a known vector of observations, \eqn{X \in \mathrm{R}^{nm\times p}} and
\eqn{Z \in \mathrm{R}^{nm\times n} } design matrices for \eqn{\beta} and \eqn{v} respectively,
\eqn{\beta \in \mathrm{R}^p} and \eqn{v\in \mathrm{R}^n} unknown vectors of fixed effects and random effects where
\eqn{v_i \sim N(0,\lambda_i)}, and
\eqn{\epsilon \in \mathrm{R}^{nm}} an unknown vector random errors independent of random effects. Note that \eqn{Z}
does not need to be provided by a user since it is automatically created accordingly to the problem specification.
}
\examples{
## small setting for data generation
n = 100; m = 2; p = 2
nm = n*m;   nmp = n*m*p

## generate artifical data
X = matrix(rnorm(nmp, 2,1), nm,p) # design matrix
Y = rnorm(nm, 2,1)                # observation

Mu = rep(1, times=nm)
Lambda = rep(1, times=n)

## solve
ans = SolveHMME(X, Y, Mu, Lambda)


}
\references{
\insertRef{henderson_estimation_1959}{HMMEsolver}

\insertRef{robinson_that_1991}{HMMEsolver}

\insertRef{mclean_unified_1991}{HMMEsolver}

\insertRef{kim_fast_2017}{HMMEsolver}
}
