% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlleleTrim.R
\name{getField}
\alias{getField}
\title{Trim Colon-Delimited HLA Allele Names by Field}
\usage{
getField(allele, res, append = FALSE)
}
\arguments{
\item{allele}{A character string representing an HLA allele.}

\item{res}{A numeric describing the resolution desired.}

\item{append}{A logical. When append = TRUE, the expression variant suffix of a full-length allele name is appended to a truncated allele name. The default value is FALSE.}
}
\value{
A version of the 'allele' character string that has been trimmed to 'res' resolution.
}
\description{
Trims a properly formatted colon-delimited HLA allele name to a desired number of fields.

If an allele name with an expression-variant suffix is truncated, the suffix can be appended to the end of the truncated allele name. If a resolution value greater then the number of fields in the submitted field is specified, the original allele is returned.
}
\note{
For internal HLAtools use.
}
\examples{
getField("HLA-A*01:01:01:01", 3)
getField("DRB1*11:01:01:12N", 2,TRUE)

}
