% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoMeans.R
\name{twoMeans}
\alias{twoMeans}
\title{CZZZ-test for two sample mean vectors}
\usage{
twoMeans(X, Y, m = 2500, filter = TRUE, SX = NULL, SY = NULL,
  alpha = 0.05, DNAME)
}
\arguments{
\item{X}{The n x p training data matrix.}

\item{Y}{The n x p training data matrix.}

\item{m}{The number of repetition in the test, default to be 2500}

\item{filter}{A logical indicator of the filtering process, default to be TRUE}

\item{SX}{The covariance matrix of X, if not presented it will be estimated from
the input sample.}

\item{SY}{The covariance matrix of T, if not presented it will be estimated from
the input sample.}

\item{alpha}{The significant level of the test.}

\item{DNAME}{Defaulf input.}
}
\value{
Value of testing statistics, p-values (the non-studentized statistic
and the studentized statistic respectively), alternative hypothesis, and the name of testing procedure.
}
\description{
Testing the equality of two sample high dimensional mean vectors using the method developed in arXiv:1406.1939 [math.ST]
}
\details{
Implement the method developed in  arXiv:1406.1939 [math.ST] to test whether a high dimensional mean vector is zero or not, which is equivalent
to test \eqn{H_0: \mu_1=\mu_2}. The procedure utilizes bootstrap concept and derive the critical values using
independent Gaussian vectors whose covariance is estimated using sample covariance matrix.
}
\author{
Tong He
}
\references{
J. Chang, W. Zhou and W.-X. Zhou, Simulation-Based Hypothesis Testing of High Dimensional Means Under Covariance Heterogeneity (2014), arXiv:1406.1939.
}

