% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deuteration_woods_plots.R
\name{deuteration_woods_timecourse}
\alias{deuteration_woods_timecourse}
\title{Return woods plots for the timecourse}
\usage{
deuteration_woods_timecourse(
  input_data,
  states,
  replicates = 3,
  ylim = c(0, 120),
  ...
)
}
\arguments{
\item{input_data}{output from function output_tc(..., percent=TRUE)}

\item{states}{states, if missing all states used}

\item{replicates}{replicates}

\item{ylim}{y axis limits}

\item{...}{other parameters}
}
\value{
Woods plots for the timecourse
}
\description{
All the peptides are plotted based on their uptake.
}
\examples{
\donttest{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tc(file_nm, percent=TRUE)
deuteration_woods_timecourse(a)
}
}
