% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern_isotropic}
\alias{matern_isotropic}
\title{Isotropic Matern covariance function}
\usage{
matern_isotropic(covparms, locs)
}
\arguments{
\item{covparms}{A vector giving positive-valued covariance parameters
in the form (variance, range, smoothness, nugget)}

\item{locs}{A matrix with \code{n} rows and \code{d} columns.
Each row of locs gives a point in R^d.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{locs[i,]} and
\code{locs[j,]}.
}
\description{
From a matrix of locations and covariance parameters of the form
(variance, range, smoothness, nugget), return the square matrix of
all pairwise covariances.
}
\section{Parameterization}{

The covariance parameter vector is (variance, range, smoothness, nugget)
= \eqn{(\sigma^2,\alpha,\nu,\tau^2)}, and the covariance function is parameterized
as
\deqn{ M(x,y) = \sigma^2 2^{1-\nu}/\Gamma(\nu) ( || x - y || / \alpha )^\nu K_\nu( || x - y || / \alpha )  }
The nugget value \eqn{ \sigma^2 \tau^2 } is added to the diagonal of the covariance matrix.
NOTE: the nugget is \eqn{ \sigma^2 \tau^2 }, not \eqn{ \tau^2 }. The reason for this choice
is for simpler profiling of \eqn{ \sigma^2 }.
}

