% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs.R
\name{boxPropGrob}
\alias{boxPropGrob}
\title{Create a box with a color split}
\usage{
boxPropGrob(label, label_left, label_right, prop, y = unit(0.5, "npc"),
  x = unit(0.5, "npc"), width, height, just = "center", bjust = "center",
  txt_gp = gpar(color = "black"), txt_left_gp = gpar(col = "black"),
  txt_right_gp = gpar(col = "black"), box_left_gp = gpar(fill = "#81BFD4"),
  box_right_gp = gpar(fill = "#D8F0D1"), box_highlight_gp = gpar(fill =
  "#ffffff55", col = NA), name = NULL)
}
\arguments{
\item{label}{The label to print}

\item{label_left}{The label for the left area}

\item{label_right}{The label for the right area}

\item{prop}{The proportion to split along}

\item{y}{The y position to put the box at. Can be either in \code{npc} (i.e. 0-1) or a \code{\link[grid]{unit}}.}

\item{x}{The x position to put the box at. Can be either in \code{npc} (i.e. 0-1) or a \code{\link[grid]{unit}}.}

\item{width}{The box autosizes but you can force by specifying the width}

\item{height}{The box autosizes but you can force by specifying the height}

\item{just}{The justification for the text: left, center or right.}

\item{bjust}{The justification for the box: left, center, right, top or bottom.
See the \code{just} option for the \code{\link[grid]{viewport}}}

\item{txt_gp}{The \code{\link[grid]{gpar}} style to apply to the text.}

\item{txt_left_gp}{The \code{\link[grid]{gpar}} style to apply to the left text.}

\item{txt_right_gp}{The \code{\link[grid]{gpar}} style to apply to the right text.}

\item{box_left_gp}{The \code{\link[grid]{gpar}} style to apply to the left box.}

\item{box_right_gp}{The \code{\link[grid]{gpar}} style to apply to the right box.}

\item{box_highlight_gp}{The \code{\link[grid]{gpar}} style to apply to the background of the main label.}

\item{name}{a character identifier for the grob. Used to find the grob on the display 
list and/or as a child of another grob.}
}
\value{
A box grob
}
\description{
Creates a grob box with text inside it and a color split in the
horizontal axes that allow indicating different proportions. The
box can also have a title that spanse the two color areas and
that has its own background.
}
\examples{
library(grid)
grid.newpage()
boxPropGrob("Main label", "Left text", "Right text", prop = .3)
}
\seealso{
Other box-functions: \code{\link{boxGrob}},
  \code{\link{connectGrob}}
}

