% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotJenks.R
\name{plotJenks}
\alias{plotJenks}
\title{R function for plotting univariate classification using Jenks' natural break method}
\usage{
plotJenks(data, n = 3, brks.cex = 0.7, top.margin = 10, dist = 5)
}
\arguments{
\item{data}{Vector storing the data.}

\item{n}{Number of  classes in which the dataset must be broken down (3 by default).}

\item{brks.cex}{Adjusts the size of the labels used in the returned plot to display the classes'
break-points.}

\item{top.margin}{Adjusts the distance of the labels from the top margin of the returned chart.}

\item{dist}{Adjusts the distance of the labels from the dot used to display the data points.}
}
\value{
The function returns a list containing the following components: \itemize{
 \item{$info: }{information about whether or not the method created non-unique breaks}
 \item{$classif: }{created classes and number of observations falling in each class}
 \item{$classif$brks: }{classes' break-points}
 \item{$breaks$max.GoF: }{number of classes at which the maximum GoF is achieved}
 \item{$class.data: }{dataframe storing the values and the class in which each value actually
 falls into}
}
}
\description{
The function  allows to break a dataset down into a user-defined number of breaks and to nicely
plot the results, adding a number of other relevant information. Implementing the Jenks' natural
breaks method, it allows to find the best arrangement of values into different classes.\cr
}
\details{
The function produces a chart in which the values of the input variable are arranged on the
x-axis in ascending order, while the index of the individual observations is reported on the
y-axis. Vertical dotted red lines correspond to the optimal break-points which best divide the
input variable into the selected classes. The break-points (and their values) are reported in the
upper part of the chart, onto the corresponding break lines. Also, the chart's subtitle reports
the Goodness of Fit value relative to the selected partition, and the partition which correspond
to the maximum GoF value.
}
\examples{
#create a toy dataset
mydata <- rnorm(100, 30, 10)

# performs the analysis, using 6 as number of desired classes,
# and store the results in the 'res' object
res <- plotJenks(mydata, n=6)

}
\keyword{plotJenks}
