% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_sequence.R
\name{simulate_sequence}
\alias{simulate_sequence}
\title{Individual based simulation of the breakdown of contiguous ancestry blocks.}
\usage{
simulate_sequence(
  input_data = NA,
  pop_size = NA,
  initial_frequencies = NA,
  total_runtime = 100,
  morgan = 1,
  recombination_rate = NA,
  num_threads = 1,
  select_matrix = NA,
  markers = NA,
  verbose = FALSE,
  multiplicative_selection = TRUE,
  mutation_rate = 0,
  substitution_matrix = matrix(1/4, 4, 4)
)
}
\arguments{
\item{input_data}{Genomic data used as input, should be of type
genomeadmixr_data. Either a single dataset is provided, or a list of
multiple genomeadmixr_data objects.}

\item{pop_size}{Vector containing the number of individuals in both
populations.}

\item{initial_frequencies}{A vector describing the initial contribution of
each provided input data set to the starting hybrid swarm. By default, equal
frequencies are assumed. If a vector not summing to 1 is provided, the vector
is normalized.}

\item{total_runtime}{Number of generations}

\item{morgan}{Length of the chromosome in Morgan (e.g. the number of
crossovers during meiosis)}

\item{recombination_rate}{rate in cM / Mbp, used to map recombination to the
markers. If the recombination_rate is not set, the value for Morgan is used,
assuming that the markers included span an entire chromosome.}

\item{num_threads}{number of threads. Default is 1. Set to -1 to use all
available threads}

\item{select_matrix}{Selection matrix indicating the markers which are under
selection. If not provided by the user, the simulation proceeds neutrally. If
provided, each row in the matrix should contain five entries:
\code{location}{ location of the marker under selection (in Morgan) }
\code{fitness of wildtype (aa)} \code{fitness of heterozygote (aA)}
\code{fitness of homozygote mutant (AA)} \code{Ancestral type that
represents the mutant allele A}}

\item{markers}{A vector of locations of markers, these markers are
tracked for every generation.}

\item{verbose}{Verbose output if TRUE. Default value is FALSE}

\item{multiplicative_selection}{Default: TRUE. If TRUE, fitness is calculated
for multiple markers by multiplying fitness values for each marker. If FALSE,
fitness is calculated by adding fitness values for each marker.}

\item{mutation_rate}{the per base probability of mutation. Default is 0.}

\item{substitution_matrix}{a 4x4 matrix representing the probability of
mutating to another base (where [1/2/3/4] = [a/c/t/g]), conditional on the
event of a mutation happening. Default is the JC69 matrix, with equal
probabilities for all transitions / transversions.}
}
\value{
A list with: \code{population} a population object, and three tibbles
with allele frequencies (only contain values of a vector was provided to the
argument \code{markers}: \code{frequencies} , \code{initial_frequencies} and
\code{final_frequencies}. Each tibble contains four columns, \code{time},
\code{location}, \code{ancestor} and \code{frequency}, which indicates the
number of generations, the location along the chromosome of the marker, the
ancestral allele at that location in that generation, and finally, the
frequency of that allele.
}
\description{
Individual based simulation of the breakdown of contiguous
ancestry blocks, with or without selection. Simulations can be started from
scratch, or from a predefined input population.
}
