#' @name rasters
#' @docType data
#'
#' @title Subset of raster data for Columbia spotted frog (Rana luteiventris)  
#'
#' @description Subset of data used in Murphy et al., (2010)
#'
#' @format A raster RasterStack:
#' \describe{
#' \item{rows}{426}
#' \item{columns}{358}
#' \item{resoultion}{30 meter}
#' \item{projection}{"+proj=utm +zone=11 +datum=NAD83 +units=m +no_defs +ellps=GRS80 +towgs84=0,0,0"}
#' \item{cti}{Compound Topographic Index ("wetness")}
#' \item{err27}{Elevation Relief Ratio}
#' \item{ffp}{Frost Free Period}
#' \item{gsp}{Growing Season Precipitation}
#' \item{hil}{Heat Load Index}
#' \item{nlcd}{USGS Landcover}
#' }
#'
#' @references
#' Murphy M.A., R. Dezzani, D.S. Pilliod & A.S. Storfer (2010) Landscape genetics of high mountain frog metapopulations. Molecular Ecology 19(17):3634-3649 
#'
NULL