% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods_GeDSboost-GeDSgam.R
\name{bl_imp.GeDSboost}
\alias{bl_imp.GeDSboost}
\alias{bl_imp}
\title{Base Learner Importance for GeDSboost objects}
\usage{
\method{bl_imp}{GeDSboost}(object, boosting_iter_only = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{\link{GeDSboost-class}}.}

\item{boosting_iter_only}{logical value, if \code{TRUE} then base-learner
in-bag risk reduction is only computed across boosting iterations, i.e.,
without taking into account a potential initial GeDS learner.}

\item{...}{potentially further arguments.}
}
\value{
An object of class \code{varimp} with available \code{plot},
\code{print} and \code{as.data.frame} methods.
}
\description{
S3 method for \code{\link{GeDSboost-class}} objects that calculates the
in-bag risk reduction ascribable to each base-learner of an FGB-GeDS model.
Essentially, it measures and aggregates the decrease in the empirical risk
attributable to each base-learner for every time it is selected across the
boosting iterations. This provides a measure on how much each base-learner
contributes to the overall improvement in the model's accuracy, as reflectedp
by the decrease in the empiral risk (loss function). This function is adapted
from \code{\link[mboost]{varimp}} and is compatible with the available
\code{\link[mboost]{mboost-package}} methods for \code{\link[mboost]{varimp}},
including \code{plot}, \code{print} and \code{as.data.frame}.
}
\details{
See \code{\link[mboost]{varimp}} for details.
}
\examples{
library(GeDS)
library(TH.data)
set.seed(290875)
data("bodyfat", package = "TH.data")
data = bodyfat
Gmodboost <- NGeDSboost(formula = DEXfat ~ f(hipcirc) + f(kneebreadth) + f(anthro3a),
                        data = data, initial_learner = FALSE)
MSE_Gmodboost_linear <- mean((data$DEXfat - Gmodboost$predictions$pred_linear)^2)
MSE_Gmodboost_quadratic <- mean((data$DEXfat - Gmodboost$predictions$pred_quadratic)^2)
MSE_Gmodboost_cubic <- mean((data$DEXfat - Gmodboost$predictions$pred_cubic)^2)

# Print MSE
cat("\n", "MEAN SQUARED ERROR", "\n",
    "Linear NGeDSboost:", MSE_Gmodboost_linear, "\n",
    "Quadratic NGeDSboost:", MSE_Gmodboost_quadratic, "\n",
    "Cubic NGeDSboost:", MSE_Gmodboost_cubic, "\n")

# Base Learner Importance
bl_imp <- bl_imp(Gmodboost)
print(bl_imp)
plot(bl_imp)

}
\references{
Hothorn T., Buehlmann P., Kneib T., Schmid M. and Hofner B. (2022).
mboost: Model-Based Boosting. R package version 2.9-7, \url{https://CRAN.R-project.org/package=mboost}.
}
