% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeDSClass.R
\docType{class}
\name{GeDSboost-class}
\alias{GeDSboost-class}
\alias{GeDSboost-Class}
\title{GeDSboost Class}
\description{
A fitted GeDSboost object returned by the function \code{\link{NGeDSboost}},
inheriting the methods for class \code{"GeDSboost"}. Methods for functions
\code{coef}, \code{knots}, \code{plot}, \code{print}, \code{predict},
\code{visualize_boosting}, and \code{bl_imp} are available.
}
\section{Slots}{

\describe{
\item{\code{extcall}}{call to the \code{\link{NGeDSboost}} function.}

\item{\code{formula}}{a formula object representing the model to be fitted.}

\item{\code{args}}{a list containing the arguments passed to the \code{\link{NGeDSboost}}
function. This list includes:
\itemize{
  \item \code{response}: \code{data.frame} containing the response variable
  observations.
  \item \code{predictors}: \code{data.frame} containing the observations
  corresponding to the predictor variables included in the model.
  \item \code{base_learners}: description of model's base learners.
  \item \code{family}: the statistical family; the possible options are
  \itemize{
  \item \code{mboost::Binomial(type = c("adaboost", "glm"),
  link = c("logit", "probit", "cloglog", "cauchit", "log"), ...)}
  \item \code{mboost::Gaussian()}
  \item \code{mboost::Poisson()}
  \item \code{mboost::GammaReg(nuirange = c(0, 100))}
  }
  Other \code{mboost} families may be suitable; however, these have not yet
  been thoroughly tested and are therefore not recommended for use.
  \item \code{initial_learner}: if \code{TRUE} a \code{\link{NGeDS}} or
  \code{\link{GGeDS}} fit was used as the initial learner; otherwise, the
  empirical risk minimizer corresponding to the selected \code{family}
  was employed.
  \item \code{int.knots_init}: if \code{initial_learner = TRUE}, this
  corresponds to the maximum number of internal knots set in the
  \code{\link{NGeDS}}/\code{\link{GGeDS}} function before the initial learner
  fit.
  \item \code{shrinkage}: shrinkage/step-length/learning rate utilized
  throughout the boosting iterations.
  \item \code{normalize_data}: if \code{TRUE}, then response and predictors
  were standardized before running the FGB algorithm.
  \item \code{X_mean}: mean of the predictor variables (only if
  \code{normalize_data = TRUE}, otherwise this is \code{NULL}).
  \item \code{X_sd}: standard deviation of the predictors (only if
  \code{normalize_data = TRUE}, otherwise this is \code{NULL}).
  \item \code{Y_mean}: mean of the response variable (only if
  \code{normalize_data = TRUE}, otherwise this is \code{NULL}).
  \item \code{Y_sd}: standard deviation of the response variable (only if
  \code{normalize_data = TRUE}, otherwise this is \code{NULL}).
}}

\item{\code{models}}{A list containing the 'model' generated at each boosting
iteration. Each of these \code{models} includes:
\itemize{
 \item \code{best_bl}: fit of the base learner that minimized the residual
 sum of squares (RSS) in fitting the gradient at the \emph{i}-th boosting
 iteration.
  \item \code{Y_hat}: model fitted values at the \emph{i}-th boosting
  iteration.
  \item \code{base_learners}: knots and polynomial coefficients for each of the
  base-learners at the \emph{i}-th boosting iteration.  
}}

\item{\code{final_model}}{A list detailing the final GeDSboost model after the
gradient descent algorithm is run:
\itemize{
\item \code{model_name}: the boosting iteration corresponding to the final
 model.
 \item \code{DEV}: deviance of the final model.
 \item \code{Y_hat}: fitted values.
 \item \code{base_learners}: a list containing, for each base-learner, the
 intervals defined by the piecewise linear fit and its corresponding
 polynomial coefficients. It also includes the knots corresponding to each
 order fit, which result from computing the corresponding averaging knot
 location. See Kaishev et al. (2016) for details. If the number of internal
 knots of the final linear fit is less than $n-1$, the averaging knot location
 is not computed.
 \item \code{Linear.Fit}/\code{Quadratic.Fit}/\code{Cubic.Fit}: final linear,
 quadratic and cubic fits in B-spline form. These include the same elements
 as \code{Linear}, \code{Quadratic} and \code{Cubic} in a \code{\link{GeDS-class}}
 object (see \code{\link{SplineReg}} for details).
 }}

\item{\code{predictions}}{a list containing the predicted values obtained for each of
the fits (linear, quadratic and cubic).}

\item{\code{internal_knots}}{a list detailing the internal knots obtained for each of
the different order fits (linear, quadratic, and cubic).}
}}

\references{
Dimitrova, D. S., Kaishev, V. K., Lattuada, A. and Verrall, R. J.  (2023).
Geometrically designed variable knot splines in generalized (non-)linear
models.
\emph{Applied Mathematics and Computation}, \strong{436}. \cr
DOI: \doi{10.1016/j.amc.2022.127493}

Dimitrova, D. S., Guillen, E. S. and Kaishev, V. K.  (2024).
\pkg{GeDS}: An \proglang{R} Package for Regression, Generalized Additive
Models and Functional Gradient Boosting, based on Geometrically Designed
(GeD) Splines. \emph{Manuscript submitted for publication.}
}
