% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NContributorsRule.R
\name{NContributorsRule}
\alias{NContributorsRule}
\title{Number of contributors suppression rule}
\usage{
NContributorsRule(
  data,
  freq,
  numVar,
  x,
  maxN = 3,
  protectZeros = FALSE,
  charVar = NULL,
  removeCodes = character(0),
  remove0 = TRUE,
  ...
)
}
\arguments{
\item{data}{Input data as a data frame}

\item{freq}{Vector of aggregate frequencies}

\item{numVar}{Numerical variables. When several variables, only first is used.}

\item{x}{Model matrix generated by parent function}

\item{maxN}{Primary suppression when number of contributors \verb{<= maxN}.}

\item{protectZeros}{Suppression parameter. Only TRUE (default) is used implemented.}

\item{charVar}{Variable(s) with contributor codes.
When empty, unique contributor in each row is assumed.
When several variables, see details.}

\item{removeCodes}{Vector of codes to be omitted when counting contributors.
With empty \code{charVar} row indices are assumed
and conversion to integer is performed.}

\item{remove0}{When set to \code{TRUE} (default), data rows in which the first \code{numVar} (if any) is zero
are excluded from the count of contributors.
Alternatively, \code{remove0} can be specified as one or more variable names.
In this case, all data rows with a zero in any of the specified variables
are omitted from the contributor count.
Specifying \code{remove0} as variable name(s) is useful for avoiding warning when there
are multiple \code{numVar} variables.}

\item{...}{unused parameters}
}
\value{
List where first element is logical vector defining primary suppressions.
The second element is data frame where \code{nRule} is number contributors used
in rule and where \code{nAll} is similar, but without omitting codes in \code{removeCodes}.
}
\description{
The number of contributors is the number unique contributing 'charVar' codes.
}
\details{
When several \code{charVar} variables, the rule is applied independently to each variable.
Primary suppression in at least one case results in  primary suppression in the output.
It is possible to specify \code{maxN} and \code{removeCodes} independently for each \code{charVar} by using a
named list as input with \code{charVar} as names. E.g. \code{maxN = list(char1 = 3, char2 = 2)}.
}
