% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_state.R
\name{addStateMatrix}
\alias{addStateMatrix}
\title{addStateMatrix}
\usage{
addStateMatrix(newMatrix, oldMatrix,
               stateName=paste("state", after+1, sep=" "),
               after=dim(oldMatrix)[1], newCell="NULL")
}
\arguments{
\item{newMatrix}{an empty matrix with one more row and one more column than the old}

\item{oldMatrix}{a matrix to which we are adding a new state;}

\item{stateName}{the name of the state to be added;}

\item{after}{the number of the state after which a new state should be added}

\item{newCell}{the value in the state to be added;}
}
\value{
\code{newMatrix}
a matrix created by adding a new state with the value \code{newCell} 
to the old matrix
}
\description{
Adds a new state to a transitions functions matrix.
}
\examples{
M <- generateHazardMatrix(5)
largeM <- generateHazardMatrix(6)
oldM <- M@list.matrix
newM <- largeM@list.matrix
M_addedState <- addStateMatrix(newM, oldM, stateName ="newState", after =3, newCell=0)
}
