% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_gtfs.R
\name{merge_gtfs}
\alias{merge_gtfs}
\title{Merge Two GTFS Datasets}
\usage{
merge_gtfs(gtfs.x, gtfs.y, suffix = TRUE)
}
\arguments{
\item{gtfs.x}{The first GTFS dataset, ideally of class `wizardgtfs`. If not, it will be converted.}

\item{gtfs.y}{The second GTFS dataset, ideally of class `wizardgtfs`. If not, it will be converted.}

\item{suffix}{A logical value. If `TRUE`, appends `.x` and `.y` suffixes to identifier columns in `gtfs.x` and `gtfs.y`, respectively, to prevent conflicts.}
}
\value{
A merged `wizardgtfs` object containing all records from `gtfs.x` and `gtfs.y` across GTFS tables.
}
\description{
`merge_gtfs` combines two GTFS datasets into a single `wizardgtfs` object, with an option to append suffixes to ensure unique identifiers across tables.
}
\details{
- When `suffix = TRUE`, unique suffixes are appended to key identifiers in `gtfs.x` and `gtfs.y` (e.g., `agency_id`, `route_id`, `trip_id`).

- After suffix handling, the function merges individual tables, ensuring no duplicated entries.

- Finally, the resulting list is converted into a `wizardgtfs` object.
}
\note{
This function assumes that both input datasets follow GTFS structure. Non-standard tables or columns may be ignored or cause warnings.
}
\examples{
# Merge two GTFS datasets with suffix handling
merged_gtfs <- merge_gtfs(for_rail_gtfs, for_bus_gtfs, suffix = TRUE)

}
\seealso{
[GTFSwizard::as_wizardgtfs()]
}
