% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_headways.R
\name{get_headways}
\alias{get_headways}
\title{Calculate Headways in GTFS Data}
\usage{
get_headways(gtfs, method = "by.route")
}
\arguments{
\item{gtfs}{A GTFS object, ideally of class `wizardgtfs`. If not, it will be converted.}

\item{method}{A character string specifying the calculation method. Options include:
\describe{
  \item{"by.route"}{Calculates the average headway for each route, assuming constant headways along stops.}
  \item{"by.hour"}{Calculates the hourly headway for each route, assuming constant headways along stops.}
  \item{"by.trip"}{Calculates headways for each trip, assuming constant headways along stops.}
  \item{"detailed"}{Calculates detailed headways between consecutive stops within each route and trip.}
}}
}
\value{
A data frame containing service headways based on the specified method:
  \describe{
    \item{If `method = "by.route"`}{Returns a data frame with columns: `route_id`, `trips`, `average.headway`, `service_pattern`, and `pattern_frequency`.}
    \item{If `method = "by.hour"`}{Returns a data frame with columns: `hour`, `trips`, `average.headway`, `service_pattern`, and `pattern_frequency`.}
    \item{If `method = "by.trip"`}{Returns a data frame with columns: `route_id`, `trip_id`, `headway`, `service_pattern`, and `pattern_frequency`.}
    \item{If `method = "detailed"`}{Returns a data frame with columns: `route_id`, `trip_id`, `stop_id`, `hour`, `headway`, `service_pattern`, and `pattern_frequency`.}
  }
}
\description{
The `get_headways` function calculates headways within a `wizardgtfs` object using different methods. Depending on the selected `method`, it can provide average headways by route, by trip, by hour, or detailed stop-level headways.
}
\details{
This function calls specific sub-functions based on the selected method:

- "by.route": Calculates the average headway for each route based on the first stop time per trip.

- "by.hour": Calculates the hourly headway for each route, grouping trips by hour.

- "by.trip": Calculates headways for each trip, considering only the first stop time.

- "detailed": Provides headway calculations for each consecutive stop within each trip.

If an invalid `method` is specified, the function defaults to `"by.route"` and provides a warning.
}
\examples{
# Calculate average route headways
headways_by_route <- get_headways(gtfs = for_rail_gtfs, method = "by.route")

# Calculate hourly headways
headways_by_hour <- get_headways(gtfs = for_rail_gtfs, method = "by.hour")

# Calculate headways for each trip
headways_by_trip <- get_headways(gtfs = for_rail_gtfs, method = "by.trip")

# Calculate detailed stop-level headways
detailed_headways <- get_headways(gtfs = for_rail_gtfs, method = "detailed")

}
\seealso{
[GTFSwizard::as_wizardgtfs()], [GTFSwizard::get_servicepattern()]
}
