% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_stations.R
\name{nearest_stations}
\alias{nearest_stations}
\title{Find nearest GSOD stations to a specified latitude and longitude}
\usage{
nearest_stations(LAT, LON, distance)
}
\arguments{
\item{LAT}{Latitude expressed as decimal degrees (DD) (WGS84)}

\item{LON}{Longitude expressed as decimal degrees (DD) (WGS84)}

\item{distance}{Distance in kilometres from point for which stations are to
be returned.}
}
\value{
By default a class \code{\link[base]{character}}
 \code{\link[base]{vector}} object of station identification numbers.
 in order from nearest to farthest in increasing order.  If
 \code{return_full} is \code{TRUE}, a \code{\link[data.table]{data.table}}
 with full station metadata including the distance from the user specified
 coordinates is returned.
}
\description{
Given latitude and longitude values entered as decimal degrees (DD), this
function returns a list (as an atomic vector) of station ID
values, which can be used in \code{\link{get_GSOD}} to query for specific
stations as an argument in the \code{station} parameter of that function.
}
\note{
The \acronym{GSOD} data, which are downloaded and manipulated by
\CRANpkg{GSODR} stipulate that the following notice should be given.
\dQuote{The following data and products may have conditions placed on their
international commercial use.  They can be used within the U.S. or for non-
commercial international activities without restriction.  The non-U.S. data
cannot be redistributed for commercial purposes.  Re-distribution of these
data by others must provide this same notification.}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Find stations within a 100km radius of Toowoomba, QLD, AUS

n <- nearest_stations(LAT = -27.5598, LON = 151.9507, distance = 100)
n
\dontshow{\}) # examplesIf}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
