% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfunctions.R
\name{NormMax}
\alias{NormMax}
\title{Normalize dictionary atoms using \eqn{l_{\infty}} norm}
\usage{
NormMax(D, cor_bnd = 0.95)
}
\arguments{
\item{D}{The dictionary to be normalized.}

\item{cor_bnd}{An upper bound of the correlation between atoms.}
}
\value{
The nomalized dictionary.
}
\description{
Remove zero columns of D. Then let \eqn{D=(D_1,...,D_p)}. The normalization is done by
\deqn{D_ik=D_ik/max_k D_ik, for i=1,...,p.}
For any D_i, and D_j, if Cor(D_i,D_j)> cor_bnd, one of D_i and D_j is eliminated.
}
\examples{
D=matrix(rnorm(50),nrow=5)
D=NormMax(D)

}
