% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen_plots.R
\name{simobs_annual_plot}
\alias{simobs_annual_plot}
\title{Scatter plot comparing observed vs modeled loads by year}
\usage{
simobs_annual_plot(
  catch_data,
  annual_data,
  alpha_p,
  alpha_l,
  sd_coef,
  years,
  name_basin,
  max_value
)
}
\arguments{
\item{catch_data}{data frame. Definition of the topological sequence of
catchments.}

\item{annual_data}{data frame. Sources of nutrient for each year and
catchments.}

\item{alpha_p}{numeric. First model parameter, the basin retention
coefficient.}

\item{alpha_l}{numeric. Second model parameter, the river retention
coefficient.}

\item{sd_coef}{numeric. Third model parameter, fraction of domestic diffuse
sources that reaches the stream network.}

\item{years}{numeric. Years to be shown in the plot.}

\item{name_basin}{character. The title of the plot.}

\item{max_value}{numeric. The maximum value for x and y axis.}
}
\value{
Multiple scatter plot and a data frame with annual nutrient
(nitrogen or phosphorus) load for all catchments in the basin
}
\description{
Plot
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)
# the parameter to assess the basin model
alpha_p <- 35.09
alpha_l <- 0.02
sd_coef <- 0.2
# years in which the plot will we shown
years <- 1990:2018
maxvalue <- 10
# generating the scatter plot comparing observed vs modeled loads by year
name_basin <- "Lay NSE"
max_value <- 10
simobs_annual_plot(catch_data_TN, annual_data_TN, alpha_p, alpha_l,
sd_coef, years, name_basin, max_value)
}

}
