% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitseq_plotGP.R
\name{bitseq_plotGP}
\alias{bitseq_plotGP}
\title{Plotting fitted GP models for the BitSeq example}
\usage{
bitseq_plotGP(item, GPfits, gpData, multi = 0, ylimits = NULL,
  x_ticks = NULL, x_label = NULL, y_label = NULL, plotName = NULL,
  colScale = getColorVector())
}
\arguments{
\item{item}{Name of the item whose GP profile to be plotted.}

\item{GPfits}{List structure obtained by \code{bitseq_fitGPs} which contains
the time-independent and time-dependent GP models for specified (?) item.}

\item{gpData}{List structure obtained by, for example, \code{bitseq_rnaSeqData} function.}

\item{multi}{Indicator value for specifying whether multiple plots (1)
or a single plot (0) will be plotted on the same frame. Default value
is 0.}

\item{ylimits}{Numeric vector which contains minimum and maximum limits for the y axis.}

\item{x_ticks}{X-axis tick labels.}

\item{x_label}{X-axis label.}

\item{y_label}{Y-axis label.}

\item{plotName}{Name of the plot containing png or pdf extension.
png is recommended for the plots which will be displayed on the 
browser, whereas pdf is recommended for the plots which will be 
used in printed documents. The default plotting settings are
specified in \code{bitseq_setPlot} function. If you would like to use 
your own preferred settings, remember to specify them on your own.}

\item{colScale}{RGB color code of the plot. If not specified, colors are 
determined by default.}
}
\value{
GP plot(s) for the given item.
}
\description{
Function for plotting GP profiles. If the item to be plotted has 
multiple items which are associated with itself, its items can
be plotted on top of each other by setting \code{multi} to 1,
for better visual comparison. Log Bayes factors are displayed 
in legends for at most three items which have the largest
log Bayes factors.
}
\examples{
RNAseqDATA
gpData=RNAseqDATA$reltr
GPfits=bitseq_fitGPs(gpData)
item="ARAP2"
multi=1
ylimits=c(0,1)
x_ticks=c("0","5","10","20","40","80","160","320","640","1280")
x_label="Time (minutes)"
y_label="Expression level (rpkm)"
plotName="ARAP2_reltr.pdf"
bitseq_plotGP(item, GPfits, gpData, multi, ylimits, x_ticks, x_label, y_label, plotName)

}
\author{
Hande Topa, \email{hande.topa@helsinki.fi}
}
\seealso{
\code{\link{getColorVector}} \code{\link{bitseq_setPlot}} \code{\link{bitseq_fitGPs}} \code{\link{bitseq_rnaSeqData}}
}
\keyword{GP}
\keyword{multi}
\keyword{plot}

