% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regOrd.R
\name{regOrd}
\alias{regOrd}
\title{regOrd : Defines the conventional order for regressors
in the polynomial formulation}
\usage{
regOrd(nVar, dMax)
}
\arguments{
\item{nVar}{The number of variables}

\item{dMax}{The maximum degree allowed for the polynomial}
}
\value{
A matrix of exponent. Each column correspond to one
polynomial term. Each line correspond to one variable.
For example, a column of three exponents (0,2,1) correspond
to regressor X1^0 * X2^2 * X3^1, that is X2^2 * X3.
}
\description{
Defines the order convention for regressors in
polynomial. It is formulated as a matrix of explonents. Each
column of the matrix (a,b,c, ...) corresponds to one regressor 
defined as the product of X1^a * X2^b * X3^c, etc.
}
\author{
Sylvain Mangiarotti
}
\seealso{
\code{\link{poLabs}}
}

