% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGame.R
\name{plotGameGrid}
\alias{plotGameGrid}
\title{Visualisation of equilibrium solution in input/output space}
\usage{
plotGameGrid(fun = NULL, domain = NULL, n.grid, graphs = c("both",
  "design", "objective"), x.to.obj = NULL, integcontrol = NULL,
  equilibrium = c("NE", "KSE", "NKSE"), fun.grid = NULL, ...)
}
\arguments{
\item{fun}{name of the function considered}

\item{domain}{optional matrix for the bounds of the domain (for now [0,1]^d only), (two columns matrix with min and max)}

\item{n.grid}{number of divisions of the grid in each dimension (must correspond to \code{n.s} for Nash equilibriums)}

\item{graphs}{either \code{"design"}, \code{"objective"} or \code{"both"} (default) for which graph to display}

\item{x.to.obj, integcontrol}{see \code{\link[GPGame]{solve_game}} (for Nash equilibrium only)}

\item{equilibrium}{either "\code{NE}" for Nash, "\code{KSE}" for Kalai-Smoridinsky and "\code{NKSE}" for Nash-Kalai-Smoridinsky}

\item{fun.grid}{optional matrix containing the values of \code{fun} at \code{integ.pts}. Computed if not provided.}

\item{...}{further arguments to \code{fun}}
}
\value{
list returned by invisible() with elements:
\itemize{
 \item \code{trueEqdesign} design corresponding to equilibrium value \code{trueEq}
 \item \code{trueEqPoff} corresponding values of the objective
 \item \code{trueParetoFront} Pareto front
 \item \code{response.grid}
 \item \code{integ.pts, expanded.indices}
}
}
\description{
Plot equilibrium for 2 objectives test problems with evaluations on a grid. The number of variables is not limited.
}
\examples{
\dontrun{
library(GPareto)

## 2 variables
dom <- matrix(c(0,0,1,1),2)

plotGameGrid("P1", domain = dom, n.grid = 51, equilibrium = "NE")
plotGameGrid("P1", domain = dom, n.grid = rep(31,2), equilibrium = "NE") ## As in the tests
plotGameGrid("P1", domain = dom, n.grid = 51, equilibrium = "KSE")
plotGameGrid("P1", domain = dom, n.grid = rep(31,2), equilibrium = "NKSE")
plotGameGrid("P1", graphs = "design", domain = dom, n.grid = rep(31,2), equilibrium = "NKSE")

## 4 variables
dom <- matrix(rep(c(0,1), each = 4), 4)
plotGameGrid("ZDT3", domain = dom, n.grid = 25, equilibrium = "NE", x.to.obj = c(1,1,2,2))

}

}

