% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_meas.R
\name{evalMeas}
\alias{evalMeas}
\title{Evaluation measures when complete data is available}
\usage{
evalMeas(missbp, compdat = NULL, dim = c("All", "2D"))
}
\arguments{
\item{missbp}{An object of class \code{missbp} obtained from preceding function \code{missmi()}.}

\item{compdat}{Complete data matrix representing the input data of \code{missmi()}}

\item{dim}{Compare the configurations in 2D or the maximum available ("All") dimensions, default is \verb{2D}.}
}
\value{
\item{eval}{Returns a data table with five evaluation measures: Procrustes Statistic (PS), Similarity Proportion (SP), Response Profile Recovery (RPR), Absolute Mean Bias (AMB), Root Mean Squared Bias (RMSB)}
}
\description{
Calculates measures of comparison based on distances between two configurations
}
\examples{
\donttest{
data(compdat)
data(implist)
missbp <- missmi(implist) |> DRT() |> GPAbin() |> evalMeas(compdat=compdat, dim="2D")}

}
