% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_traits.R
\name{GIFT_traits}
\alias{GIFT_traits}
\title{Trait values at the species level}
\usage{
GIFT_traits(
  trait_IDs = "",
  agreement = 0.66,
  bias_ref = TRUE,
  bias_deriv = TRUE,
  api = "https://gift.uni-goettingen.de/api/extended/",
  GIFT_version = "latest"
)
}
\arguments{
\item{trait_IDs}{a character string indicating which trait you want to
retrieve. Traits must belong to the available list of traits.}

\item{agreement}{Percentage of resources that agree on an aggregated trait
value, entries below this threshold will be omitted.}

\item{bias_ref}{When FALSE, exclude entries that are only based on a
resource that potentially introduces a bias (e.g. a resource only including
trees).}

\item{bias_deriv}{When FALSE, exclude entries that are only based on a
derivation that potentially introduces a bias (e.g. all phanerophytes being
woody but some life forms being ambiguous).}

\item{api}{character string defining from which API the data will be
retrieved.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}
}
\value{
A long-format data frame with 6 columns: \code{trait_ID}, \code{work_ID}, \code{species},
\code{trait_value}, \code{agreement} and \code{references}.
}
\description{
Retrieve specific trait values.
}
\details{
Here is the detail of each column:

\emph{trait_ID} - Identification number of the trait\cr
\emph{work_ID} - Identification number of the taxonomically harmonized
species\cr
\emph{species} - Species name\cr
\emph{trait_value} - Value of the trait\cr
\emph{agreement} - Agreement score between the different sources for that
trait value, only for categorical traits\cr
\emph{cv} - Coefficient of variation for the different sources for that
trait value, only for numeric traits\cr
\emph{n} - Number of sources leading to the trait value\cr
\emph{references} - ref_ID from which we got the trait information
}
\examples{
\donttest{
self_fertilization <- GIFT_traits(trait_IDs = "3.1.1", agreement = 0.66,
bias_ref = FALSE, bias_deriv = FALSE)
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_traits_meta]{GIFT_traits_meta()}}
}
