\name{ghap.ancestral}
\alias{ghap.ancestral}

\title{
 Inference of haplotype origin
}
\description{
  Given one test population and two parental populations, the function assigns haplotype alleles in the test population to one of the parental populations.
}
\usage{
 ghap.ancestral(hapstats.test, hapstats.parent1, hapstats.parent2, freq = 0.05,
  prob.assign = 0.60)
}

\arguments{
  \item{hapstats.test}{
   A data.frame containing haplotype statistics for the population to be tested, as generated by the \code{\link{ghap.hapstats}} function.
  }
  \item{hapstats.parent1}{
   A data.frame containing haplotype statistics for the first parental population.
  }
  \item{hapstats.parent2}{
   A data.frame containing haplotype statistics for the second parental population.
  }
  \item{freq}{
   The haplotype frequency threshold used to filter haplotype alleles in the parental populations (default = 0.05). For each parental population, if the allele frequency is lower than the threshold the probability of origin is automatically set to zero. 
  }
  \item{prob.assign}{
   The probability threshold used for the assignment test (default = 0.60). Haplotypes that are not assigned to any of the parental populations are also marked as unassigned (UNK).
  }
}

\value{
The function returns a dataframe and a file with the following columns:
 \item{BLOCK}{
  Block alias.
 }
 \item{CHR}{
  Chromosome name.
 }
 \item{BP1}{
  Block start position.
 }
 \item{BP2}{
  Block end position.
 }
  \item{ALLELE}{
 Haplotype allele identity.
 }
 \item{FREQ.TEST}{
  Haplotype frequency in the test population.
 }
 \item{FREQ.PARENT[1 and 2]}{
  Haplotype frequency in the first and second parental populations, respectively.
 }
 \item{PROB.PARENT[1 and 2]}{
  Assignment probabilities calculated following Bolormaa et al. (2011).
 }
  \item{ORIGIN}{
  Haplotype origin (PARENT1, PARENT2 or UNK).
  }
}

\details{
 This function calculates the probability that one haplotype from a tested population was inherited from one of the tested parental populations. The function followed the method described by Bolormaa et al. (2011).

}

\author{
Marco Milanesi <marco.milanesi.mm@gmail.com>
}

\examples{

# #### DO NOT RUN IF NOT NECESSARY ###
# 
# # Copy the example data in the current working directory
# ghap.makefile()
# 
# # Load data
# phase <- ghap.loadphase("human.samples", "human.markers", "human.phase")
# 
# # Subset data - markers with maf > 0.05
# maf <- ghap.maf(phase, ncores = 2)
# markers <- phase$marker[maf > 0.05]
# phase <- ghap.subsetphase(phase, unique(phase$id), markers)
# 
# # Generate blocks of 5 markers sliding 5 markers at a time
# blocks.mkr <- ghap.blockgen(phase, windowsize = 5, slide = 5, unit = "marker")
#
# # Generate matrix of haplotype genotypes
# ghap.haplotyping(phase, blocks.mkr, batchsize = 100, ncores = 2, outfile = "human")
#
# # Load haplotype genotypes
# haplo <- ghap.loadhaplo("human.hapsamples", "human.hapalleles", "human.hapgenotypes")
# 
#
# ### RUN ###
#
# # Compute haplotype allele statistics for each group
# haplo <- ghap.subsethaplo(haplo,haplo$id,rep(TRUE,times=haplo$nalleles))
# ASW.ids <- unique(haplo$id[haplo$pop=="ASW"])
# YRI.ids <- unique(haplo$id[haplo$pop=="YRI"])
# CEU.ids <- unique(haplo$id[haplo$pop=="CEU"])
# haplo <- ghap.subsethaplo(haplo,YRI.ids,haplo$allele.in)
# YRI.hapstats <- ghap.hapstats(haplo,ncores = 2)
# haplo <- ghap.subsethaplo(haplo,CEU.ids,haplo$allele.in)
# CEU.hapstats <- ghap.hapstats(haplo,ncores = 2)
# haplo <- ghap.subsethaplo(haplo,ASW.ids,haplo$allele.in)
# ASW.hapstats <- ghap.hapstats(haplo,ncores = 2)
# haplo <- ghap.subsethaplo(haplo,haplo$id,rep(TRUE,times=haplo$nalleles))
#
# # Find haplotype origin
# # ASW is the test population. YRI and CEU are used as parental populations
# # The frequency threshold is set to 0.05 and the probability of assignment to 0.60
# ancestry <- ghap.ancestral(ASW.hapstats, YRI.hapstats, CEU.hapstats, 0.05, 0.60)
# ancestry <- ancestry[ancestry$FREQ.TEST > 0,]

}

\references{
S. Bolormaa et al. Detection of chromosome segments of zebu and taurine origin and their effect on beef production and growth. J. Anim. Sci. 2011. 89:2050-2060.
}
