\name{ghap.loadhaplo}
\alias{ghap.loadhaplo}

\title{
  Load haplotype genotype data
}
\description{
  This function loads HapGenotypes generated by \code{\link{ghap.haplotyping}} and converts them to a native GHap.haplo object.
}
\usage{
  ghap.loadhaplo(hapsamples.file, hapalleles.file, hapgenotypes.file, verbose = TRUE)
}

\arguments{
  \item{hapsamples.file}{
    Individual information file.
  }
  \item{hapalleles.file}{
    Haplotype alleles information file.
  }
  \item{hapgenotypes.file}{
    Haplotype genotype matrix file.
  }
  \item{verbose}{
   A logical value specifying whether log messages should be printed (default = TRUE).
  }
}
\value{
  The returned GHap.haplo object is a list with components:
  \item{nsamples}{
    An integer value for the sample size.
  }
  \item{nalleles}{
    An integer value for the number of haplotype alleles.
  }
  \item{nsamples.in}{
    An integer value for the number of active samples.
  }
  \item{nalleles.in}{
    An integer value for the number of active haplotype alleles.
  }
  \item{pop}{
    A character vector relating samples to populations. This information is obtained from the first column of the hapsamples file.
  }
  \item{id}{
    A character vector mapping genotypes to samples. This information is obtained from the second column of the hapsamples file.
  }
  \item{id.in}{
    A logical vector indicating active samples. By default, all samples are set to TRUE.
  }
  \item{chr}{
    A character vector mapping haplotype alleles to chromosomes. This information is obtained from the second column of the hapalleles file.
  }
  \item{block}{
    A character vector containing block names. This information is obtained from the first column of the hapalleles file.
  }
  \item{bp1}{
    A numeric vector with haplotype allele start positions. This information is obtained from the third column of the hapalleles file.
  }
  \item{bp2}{
    A numeric vector with haplotype allele end positions. This information is obtained from the fourth column of the hapalleles file.
  }
  \item{allele}{
    A character vector with haplotype allele identity. This information is obtained from the fifth column of the hapalleles file.
  }
  \item{allele.in}{
    A logical vector indicating active haplotype alleles. By default, all alleles are set to TRUE.
  }
  \item{genotypes}{
    A \code{\link{big.matrix}} object containing the haplotype genotype matrix
  }
  
  The input format is described in \code{\link{ghap.haplotyping}}.
}

\author{
  Yuri Tani Utsunomiya <ytutsunomiya@gmail.com>
  
  Marco Milanesi <marco.milanesi.mm@gmail.com>
}

\examples{

# #### DO NOT RUN IF NOT NECESSARY ###
# 
# # Copy the example data in the current working directory
# ghap.makefile()
# 
# # Load data
# phase <- ghap.loadphase("human.samples", "human.markers", "human.phase")
# 
# # Subset data - randomly select 3000 markers with maf > 0.02
# maf <- ghap.maf(phase, ncores = 2)
# set.seed(1988)
# markers <- sample(phase$marker[maf > 0.02], 3000, replace = FALSE)
# phase <- ghap.subsetphase(phase, unique(phase$id), markers)
# rm(maf,markers)
# 
# # Generate block coordinates based on windows of 10 markers, sliding 5 marker at a time
# blocks <- ghap.blockgen(phase, 10, 5, "marker")
# 
# 
# ### RUN ###
# 
# # Generate matrix of haplotype genotypes
# ghap.haplotyping(phase, blocks, batchsize = 100, ncores = 2, freq = 0.05, outfile = "example")
# 
# # Load haplotype genotypes
# haplo <- ghap.loadhaplo("example.hapsamples", "example.hapalleles", "example.hapgenotypes")

}

